/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.tree.DecisionTreeNode;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

public class DecisionTree<InputType, OutputType>
extends AbstractCloneableSerializable
implements Evaluator<InputType, OutputType> {
    protected DecisionTreeNode<InputType, OutputType> rootNode;

    public DecisionTree() {
        this(null);
    }

    public DecisionTree(DecisionTreeNode<InputType, OutputType> rootNode) {
        this.setRootNode(rootNode);
    }

    public OutputType evaluate(InputType input) {
        return this.evaluateNode(input, this.getRootNode());
    }

    public OutputType evaluateNode(InputType input, DecisionTreeNode<InputType, OutputType> node) {
        if (node == null) {
            return null;
        }
        if (node.isLeaf()) {
            return node.getOutput(input);
        }
        DecisionTreeNode<InputType, OutputType> child = node.chooseChild(input);
        if (child == null) {
            return node.getOutput(input);
        }
        return this.evaluateNode(input, child);
    }

    public DecisionTreeNode<InputType, OutputType> findTerminalNode(InputType input) {
        return this.findTerminalNode(input, this.getRootNode());
    }

    public DecisionTreeNode<InputType, OutputType> findTerminalNode(InputType input, DecisionTreeNode<InputType, OutputType> node) {
        if (node == null) {
            return null;
        }
        if (node.isLeaf()) {
            return node;
        }
        DecisionTreeNode<InputType, OutputType> child = node.chooseChild(input);
        if (child == null) {
            return node;
        }
        return this.findTerminalNode(input, child);
    }

    public DecisionTreeNode<InputType, OutputType> getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(DecisionTreeNode<InputType, OutputType> rootNode) {
        this.rootNode = rootNode;
    }
}

