/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.tree.AbstractVectorThresholdMaximumGainLearner;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;

@PublicationReference(author={"David A. Cieslak", "Nitesh V. Chawla"}, title="Increasing Skew Insensitivity of Decision Trees with Hellinger Distance", type=PublicationType.TechnicalReport, year=2008, publication="Notre Dame University Computer Science and Engineering Technical Reports", url="http://www.cse.nd.edu/Reports/2008/TR-2008-06.pdf")
public class VectorThresholdHellingerDistanceLearner<OutputType>
extends AbstractVectorThresholdMaximumGainLearner<OutputType> {
    @Override
    public double computeSplitGain(MapBasedDataHistogram<OutputType> baseCounts, MapBasedDataHistogram<OutputType> positiveCounts, MapBasedDataHistogram<OutputType> negativeCounts) {
        int categoryCount = baseCounts.getDomain().size();
        if (categoryCount <= 1) {
            return 0.0;
        }
        double[] sqrtPositiveProportions = new double[categoryCount];
        double[] sqrtNegativeProportions = new double[categoryCount];
        int categoryIndex = 0;
        for (Object category : baseCounts.getDomain()) {
            int total = baseCounts.getCount(category);
            int positive = positiveCounts.getCount(category);
            int negative = negativeCounts.getCount(category);
            sqrtPositiveProportions[categoryIndex] = Math.sqrt((double)positive / (double)total);
            sqrtNegativeProportions[categoryIndex] = Math.sqrt((double)negative / (double)total);
            ++categoryIndex;
        }
        double hellingerSum = 0.0;
        for (int i = 0; i < categoryCount; ++i) {
            double sqrtPositiveProportionsI = sqrtPositiveProportions[i];
            double sqrtNegativeProportionsI = sqrtNegativeProportions[i];
            for (int j = i + 1; j < categoryCount; ++j) {
                double sqrtPositiveProportionsJ = sqrtPositiveProportions[j];
                double sqrtNegativeProportionsJ = sqrtNegativeProportions[j];
                double positivePart = sqrtPositiveProportionsI - sqrtPositiveProportionsJ;
                double negativePart = sqrtNegativeProportionsI - sqrtNegativeProportionsJ;
                double hellinger = Math.sqrt(positivePart * positivePart + negativePart * negativePart);
                hellingerSum += hellinger;
            }
        }
        int count = categoryCount * (categoryCount - 1) / 2;
        return hellingerSum / (double)count;
    }
}

