/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.learning.algorithm.tree.AbstractVectorThresholdMaximumGainLearner;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;

public class VectorThresholdInformationGainLearner<OutputType>
extends AbstractVectorThresholdMaximumGainLearner<OutputType> {
    @Override
    public double computeSplitGain(MapBasedDataHistogram<OutputType> baseCounts, MapBasedDataHistogram<OutputType> positiveCounts, MapBasedDataHistogram<OutputType> negativeCounts) {
        int totalCount = baseCounts.getTotalCount();
        double entropyBase = baseCounts.getEntropy();
        double entropyPositive = positiveCounts.getEntropy();
        double entropyNegative = negativeCounts.getEntropy();
        double proportionPositive = (double)positiveCounts.getTotalCount() / (double)totalCount;
        double proportionNegative = (double)negativeCounts.getTotalCount() / (double)totalCount;
        double gain = entropyBase - proportionPositive * entropyPositive - proportionNegative * entropyNegative;
        return gain;
    }
}

