/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data.feature;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.collection.NumberComparator;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.math.AbstractUnivariateScalarFunction;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Made the learning methods take <? extends Number>", "Now extends AbstractUnivariateScalarFunction", "Cleaned up javadoc"})
public class StandardDistributionNormalizer
extends AbstractUnivariateScalarFunction {
    public static final double DEFAULT_MEAN = 0.0;
    public static final double DEFAULT_VARIANCE = 1.0;
    protected double mean;
    protected double variance;
    protected double standardDeviation;

    public StandardDistributionNormalizer() {
        this(0.0, 1.0);
    }

    public StandardDistributionNormalizer(double mean, double variance) {
        this.setMean(mean);
        this.setVariance(variance);
    }

    public StandardDistributionNormalizer(UnivariateGaussian gaussian) {
        this(gaussian.getMean(), gaussian.getVariance());
    }

    public StandardDistributionNormalizer(StandardDistributionNormalizer other) {
        this(other.getMean(), other.getVariance());
    }

    public StandardDistributionNormalizer clone() {
        return (StandardDistributionNormalizer)super.clone();
    }

    public double evaluate(double value) {
        return (value - this.mean) / this.standardDeviation;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        if (variance <= 0.0) {
            throw new IllegalArgumentException("variance must be positive");
        }
        this.variance = variance;
        this.standardDeviation = Math.sqrt(variance);
    }

    public static StandardDistributionNormalizer learn(Collection<? extends Number> values) {
        return StandardDistributionNormalizer.learn(values, 0.0);
    }

    public static StandardDistributionNormalizer learn(Collection<? extends Number> values, double outlierPercent) {
        if (values == null) {
            throw new NullPointerException("values cannot be null.");
        }
        if (outlierPercent < 0.0 || outlierPercent >= 1.0) {
            throw new IllegalArgumentException("outlierPercent must be [0.0, 1.0)");
        }
        int count = values.size();
        if (count <= 0) {
            throw new IllegalArgumentException("values cannot be empty.");
        }
        Collection<? extends Number> included = values;
        if (outlierPercent > 0.0) {
            ArrayList<? extends Number> sorted = new ArrayList<Number>(values);
            Collections.sort(sorted, NumberComparator.INSTANCE);
            int numToDiscard = (int)((double)count * outlierPercent / 2.0);
            if (numToDiscard > 0 && 2 * numToDiscard < count) {
                included = sorted.subList(numToDiscard, count - numToDiscard);
            }
        }
        count = included.size();
        Pair result = UnivariateStatisticsUtil.computeMeanAndVariance(included);
        double mean = (Double)result.getFirst();
        double variance = ((double)count - 1.0) / (double)count * (Double)result.getSecond();
        if (variance <= 0.0) {
            variance = 1.0;
        }
        return new StandardDistributionNormalizer(mean, variance);
    }

    public static class Learner
    extends AbstractCloneableSerializable
    implements BatchLearner<Collection<Double>, StandardDistributionNormalizer> {
        public static final double DEFAULT_OUTLIER_PERCENT = 0.0;
        protected double outlierPercent;

        public Learner() {
            this(0.0);
        }

        public Learner(double outlierPercent) {
            this.setOutlierPercent(outlierPercent);
        }

        @Override
        public StandardDistributionNormalizer learn(Collection<Double> values) {
            return StandardDistributionNormalizer.learn(values, this.outlierPercent);
        }

        public double getOutlierPercent() {
            return this.outlierPercent;
        }

        public void setOutlierPercent(double outlierPercent) {
            if (outlierPercent < 0.0 || outlierPercent >= 1.0) {
                throw new IllegalArgumentException("outlierPercent must be [0.0, 1.0)");
            }
            this.outlierPercent = outlierPercent;
        }
    }
}

