/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.experiment.AbstractValidationFoldExperiment;
import gov.sandia.cognition.learning.experiment.ValidationFoldCreator;
import gov.sandia.cognition.learning.performance.PerformanceEvaluator;
import gov.sandia.cognition.util.Summarizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@PublicationReference(author={"Wikipedia"}, title="Decriptive statistics", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Descriptive_statistics")
public class LearnerValidationExperiment<InputDataType, FoldDataType, LearnedType, StatisticType, SummaryType>
extends AbstractValidationFoldExperiment<InputDataType, FoldDataType>
implements PerformanceEvaluator<BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>, Collection<? extends InputDataType>, SummaryType> {
    protected PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> performanceEvaluator;
    protected Summarizer<? super StatisticType, ? extends SummaryType> summarizer;
    private BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType> learner;
    protected ArrayList<StatisticType> statistics;
    protected SummaryType summary;

    public LearnerValidationExperiment() {
        this(null, null, null);
    }

    public LearnerValidationExperiment(ValidationFoldCreator<InputDataType, FoldDataType> foldCreator, PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> performanceEvaluator, Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        super(foldCreator);
        this.setPerformanceEvaluator(performanceEvaluator);
        this.setSummarizer(summarizer);
        this.setStatistics(null);
        this.setSummary(null);
    }

    @Deprecated
    public SummaryType evaluate(BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType> learner, Collection<? extends InputDataType> data) {
        return this.evaluatePerformance(learner, data);
    }

    @Override
    public SummaryType evaluatePerformance(BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType> learner, Collection<? extends InputDataType> data) {
        List folds = this.getFoldCreator().createFolds(data);
        this.setLearner(learner);
        this.setStatistics(new ArrayList(folds.size()));
        this.setSummary(null);
        this.runExperiment(folds);
        this.setSummary(this.getSummarizer().summarize(this.getStatistics()));
        return this.getSummary();
    }

    @Override
    protected void runTrial(PartitionedDataset<FoldDataType> fold) {
        LearnedType learned = this.getLearner().learn(fold.getTrainingSet());
        Collection<FoldDataType> testingSet = fold.getTestingSet();
        StatisticType statistic = this.getPerformanceEvaluator().evaluatePerformance(learned, testingSet);
        this.statistics.add(statistic);
    }

    public PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> getPerformanceEvaluator() {
        return this.performanceEvaluator;
    }

    public void setPerformanceEvaluator(PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> performanceEvaluator) {
        this.performanceEvaluator = performanceEvaluator;
    }

    public Summarizer<? super StatisticType, ? extends SummaryType> getSummarizer() {
        return this.summarizer;
    }

    public void setSummarizer(Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        this.summarizer = summarizer;
    }

    public BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType> getLearner() {
        return this.learner;
    }

    protected void setLearner(BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType> learner) {
        this.learner = learner;
    }

    public ArrayList<StatisticType> getStatistics() {
        return this.statistics;
    }

    protected void setStatistics(ArrayList<StatisticType> statistics) {
        this.statistics = statistics;
    }

    public SummaryType getSummary() {
        return this.summary;
    }

    protected void setSummary(SummaryType summary) {
        this.summary = summary;
    }
}

