/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.data.DefaultPartitionedDataset;
import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.experiment.ValidationFoldCreator;
import gov.sandia.cognition.math.Permutation;
import gov.sandia.cognition.util.AbstractRandomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class RandomByTwoFoldCreator<DataType>
extends AbstractRandomized
implements ValidationFoldCreator<DataType, DataType> {
    public static final int DEFAULT_NUM_SPLITS = 5;
    protected int numSplits;

    public RandomByTwoFoldCreator() {
        this(5);
    }

    public RandomByTwoFoldCreator(int numSplits) {
        this(numSplits, new Random());
    }

    public RandomByTwoFoldCreator(int numSplits, Random random) {
        super(random);
        this.setNumSplits(numSplits);
    }

    @Override
    public List<PartitionedDataset<DataType>> createFolds(Collection<? extends DataType> data) {
        int size = CollectionUtil.size(data);
        if (size < 2) {
            throw new IllegalArgumentException("data must have at least 2 elements.");
        }
        int actualNumSplits = Math.min(size, this.getNumSplits());
        int actualNumFolds = 2 * actualNumSplits;
        ArrayList<PartitionedDataset<DataType>> result = new ArrayList<PartitionedDataset<DataType>>(actualNumFolds);
        int halfSize = Math.max(size / 2, 1);
        for (int i = 0; i < actualNumSplits; ++i) {
            ArrayList reordering = Permutation.createReordering(data, (Random)this.getRandom());
            List firstHalf = reordering.subList(0, halfSize);
            List secondHalf = reordering.subList(halfSize, size);
            result.add(DefaultPartitionedDataset.create(firstHalf, secondHalf));
            result.add(DefaultPartitionedDataset.create(secondHalf, firstHalf));
        }
        return result;
    }

    public int getNumSplits() {
        return this.numSplits;
    }

    public void setNumSplits(int numSplits) {
        if (numSplits <= 0) {
            throw new IllegalArgumentException("numSplits must be positive");
        }
        this.numSplits = numSplits;
    }
}

