/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.data.RandomizedDataPartitioner;
import gov.sandia.cognition.learning.experiment.ValidationFoldCreator;
import java.util.ArrayList;
import java.util.Collection;

public class RandomFoldCreator<DataType>
implements ValidationFoldCreator<DataType, DataType> {
    public static final int DEFAULT_NUM_FOLDS = 10;
    protected int numFolds;
    protected RandomizedDataPartitioner<DataType> partitioner;

    public RandomFoldCreator() {
        this(10, null);
    }

    public RandomFoldCreator(int numFolds, RandomizedDataPartitioner<DataType> partitioner) {
        this.setNumFolds(numFolds);
        this.setPartitioner(partitioner);
    }

    @Override
    public ArrayList<PartitionedDataset<DataType>> createFolds(Collection<? extends DataType> data) {
        ArrayList<PartitionedDataset<DataType>> folds = new ArrayList<PartitionedDataset<DataType>>(this.getNumFolds());
        for (int i = 0; i < this.getNumFolds(); ++i) {
            folds.add(this.partitioner.createPartition(data));
        }
        return folds;
    }

    public int getNumFolds() {
        return this.numFolds;
    }

    public void setNumFolds(int numFolds) {
        if (numFolds <= 0) {
            throw new IllegalArgumentException("numFolds must be greater than zero.");
        }
        this.numFolds = numFolds;
    }

    public RandomizedDataPartitioner<DataType> getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(RandomizedDataPartitioner<DataType> partitioner) {
        this.partitioner = partitioner;
    }
}

