/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.function.categorization.AbstractConfidenceWeightedBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;

public class DefaultConfidenceWeightedBinaryCategorizer
extends AbstractConfidenceWeightedBinaryCategorizer {
    protected Matrix covariance;

    public DefaultConfidenceWeightedBinaryCategorizer() {
        this.setCovariance(null);
    }

    public DefaultConfidenceWeightedBinaryCategorizer(Vector mean, Matrix covariance) {
        super(mean);
        this.setCovariance(covariance);
    }

    @Override
    public UnivariateGaussian evaluateAsGaussian(Vectorizable input) {
        if (!this.isInitialized()) {
            return new UnivariateGaussian();
        }
        Vector x = input.convertToVector();
        return new UnivariateGaussian(this.evaluateAsDouble(x), x.times(this.getCovariance()).dotProduct(x));
    }

    @Override
    public Matrix getCovariance() {
        return this.covariance;
    }

    public void setCovariance(Matrix covariance) {
        this.covariance = covariance;
    }
}

