/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractBatchLearnerContainer;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.AbstractCategorizer;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class EvaluatorToCategorizerAdapter<InputType, CategoryType>
extends AbstractCategorizer<InputType, CategoryType> {
    private Evaluator<? super InputType, ? extends CategoryType> evaluator;

    public EvaluatorToCategorizerAdapter() {
        this(null, new TreeSet());
    }

    public EvaluatorToCategorizerAdapter(Evaluator<? super InputType, ? extends CategoryType> evaluator, Set<CategoryType> categories) {
        super(categories);
        this.setEvaluator(evaluator);
    }

    public CategoryType evaluate(InputType input) {
        return (CategoryType)this.evaluator.evaluate(input);
    }

    public Evaluator<? super InputType, ? extends CategoryType> getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator<? super InputType, ? extends CategoryType> evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void setCategories(Set<CategoryType> categories) {
        super.setCategories(categories);
    }

    public static class Learner<InputType, CategoryType>
    extends AbstractBatchLearnerContainer<BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>>>
    implements SupervisedBatchLearner<InputType, CategoryType, EvaluatorToCategorizerAdapter<InputType, CategoryType>> {
        public Learner() {
            this(null);
        }

        public Learner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> learner) {
            this.setLearner(learner);
        }

        @Override
        public Learner<InputType, CategoryType> clone() {
            return (Learner)super.clone();
        }

        @Override
        public EvaluatorToCategorizerAdapter<InputType, CategoryType> learn(Collection<? extends InputOutputPair<? extends InputType, CategoryType>> data) {
            Evaluator<InputType, CategoryType> learned = this.getLearner().learn(data);
            TreeSet<CategoryType> categories = new TreeSet<CategoryType>();
            for (InputOutputPair<InputType, CategoryType> example : data) {
                categories.add(example.getOutput());
            }
            return new EvaluatorToCategorizerAdapter<InputType, CategoryType>(learned, categories);
        }

        @Override
        public BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> getLearner() {
            return this.learner;
        }

        @Override
        public void setLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> learner) {
            this.learner = learner;
        }
    }
}

