/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.cost;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.cost.CostFunction;
import gov.sandia.cognition.learning.function.distance.EuclideanDistanceMetric;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Justin Basilico"}, date="2006-10-04", changesNeeded=false, comments={"Switched usage for the goal from Vectorizable to just a Vector so it does not call convertToVector() over and over."})
public class EuclideanDistanceCostFunction
extends AbstractCloneableSerializable
implements CostFunction<Vectorizable, Vectorizable> {
    private Vector goal;

    public EuclideanDistanceCostFunction() {
        this(null);
    }

    public EuclideanDistanceCostFunction(Vector goal) {
        this.setCostParameters((Vectorizable)goal);
    }

    public EuclideanDistanceCostFunction clone() {
        EuclideanDistanceCostFunction clone = (EuclideanDistanceCostFunction)super.clone();
        clone.goal = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.goal);
        return clone;
    }

    @Override
    public Double evaluate(Vectorizable target) {
        return EuclideanDistanceMetric.INSTANCE.evaluate((Vectorizable)this.goal, (Vectorizable)target.convertToVector());
    }

    @Override
    public void setCostParameters(Vectorizable costParameters) {
        this.goal = costParameters == null ? null : costParameters.convertToVector();
    }

    @Override
    public Vectorizable getCostParameters() {
        return this.goal;
    }
}

