/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.DefaultWeightedValue;

public class KernelUtil {
    public static <ValueType> double norm2(ValueType value, Kernel<? super ValueType> kernel) {
        return Math.sqrt(KernelUtil.norm2Squared(value, kernel));
    }

    public static <InputType> double norm2(DefaultKernelBinaryCategorizer<InputType> target) {
        return Math.sqrt(KernelUtil.norm2Squared(target));
    }

    public static <ValueType> double norm2Squared(ValueType value, Kernel<? super ValueType> kernel) {
        return kernel.evaluate(value, value);
    }

    public static <InputType> double norm2Squared(DefaultKernelBinaryCategorizer<InputType> target) {
        double result = 0.0;
        double bias = target.getBias();
        for (DefaultWeightedValue example : target.getExamples()) {
            double sum = target.evaluateAsDouble(example.getValue()) - bias;
            result += sum * example.getWeight();
        }
        return result;
    }

    public static void scaleEquals(DefaultKernelBinaryCategorizer<?> target, double scale) {
        for (DefaultWeightedValue example : target.getExamples()) {
            double oldWeight = example.getWeight();
            double newWeight = scale * oldWeight;
            example.setWeight(newWeight);
        }
    }
}

