/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.DefaultKernelContainer;
import gov.sandia.cognition.learning.function.kernel.Kernel;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Looks fine otherwise."})
public class NormalizedKernel<InputType>
extends DefaultKernelContainer<InputType>
implements Kernel<InputType> {
    public NormalizedKernel() {
    }

    public NormalizedKernel(Kernel<? super InputType> kernel) {
        super(kernel);
    }

    public NormalizedKernel(NormalizedKernel<? super InputType> other) {
        super(other);
    }

    @Override
    public NormalizedKernel<InputType> clone() {
        return (NormalizedKernel)super.clone();
    }

    @Override
    public double evaluate(InputType x, InputType y) {
        double kxy = this.kernel.evaluate(x, y);
        if (kxy == 0.0) {
            return 0.0;
        }
        double kxx = this.kernel.evaluate(x, x);
        double kyy = this.kernel.evaluate(y, y);
        if (kxx == 0.0 || kyy == 0.0) {
            return 0.0;
        }
        return kxy / Math.sqrt(kxx * kyy);
    }
}

