/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.learning.function.scalar.KernelScalarFunction;
import gov.sandia.cognition.util.WeightedValue;
import java.util.Collection;

public class LocallyWeightedKernelScalarFunction<InputType>
extends KernelScalarFunction<InputType> {
    public static final double DEFAULT_CONSTANT_WEIGHT = 0.0;
    public static final double DEFAULT_CONSTANT_VALUE = 0.0;
    protected double constantWeight;
    protected double constantValue;

    public LocallyWeightedKernelScalarFunction() {
    }

    public LocallyWeightedKernelScalarFunction(Kernel<? super InputType> kernel) {
        super(kernel);
        this.setConstantWeight(0.0);
        this.setConstantValue(0.0);
    }

    public LocallyWeightedKernelScalarFunction(Kernel<? super InputType> kernel, Collection<? extends WeightedValue<? extends InputType>> examples) {
        this(kernel, examples, 0.0);
    }

    public LocallyWeightedKernelScalarFunction(Kernel<? super InputType> kernel, Collection<? extends WeightedValue<? extends InputType>> examples, double bias) {
        this(kernel, examples, bias, 0.0, 0.0);
    }

    public LocallyWeightedKernelScalarFunction(Kernel<? super InputType> kernel, Collection<? extends WeightedValue<? extends InputType>> examples, double bias, double constantWeight, double constantValue) {
        super(kernel, examples, bias);
        this.setConstantWeight(constantWeight);
        this.setConstantValue(constantValue);
    }

    public LocallyWeightedKernelScalarFunction(LocallyWeightedKernelScalarFunction<InputType> other) {
        super(other);
        this.setConstantWeight(other.getConstantWeight());
        this.setConstantValue(other.getConstantValue());
    }

    @Override
    public Double evaluate(InputType input) {
        double sum = this.constantWeight * this.constantValue;
        double denominator = this.constantValue;
        for (WeightedValue example : this.examples) {
            double weight = example.getWeight();
            double value = this.kernel.evaluate(input, example.getValue());
            sum += weight * value;
            denominator += value;
        }
        if (denominator == 0.0) {
            return this.bias;
        }
        return sum / denominator + this.bias;
    }

    public double getConstantWeight() {
        return this.constantWeight;
    }

    public void setConstantWeight(double constantWeight) {
        this.constantWeight = constantWeight;
    }

    public double getConstantValue() {
        return this.constantValue;
    }

    public void setConstantValue(double constantValue) {
        this.constantValue = constantValue;
    }
}

