/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.learning.function.scalar.AtanFunction;
import gov.sandia.cognition.learning.function.vector.ElementWiseVectorFunction;
import gov.sandia.cognition.learning.function.vector.MatrixMultiplyVectorFunction;
import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFunction;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.VectorOutputEvaluator;
import gov.sandia.cognition.math.matrix.VectorizableVectorFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class SquashedMatrixMultiplyVectorFunction
extends AbstractCloneableSerializable
implements VectorizableVectorFunction,
VectorInputEvaluator<Vector, Vector>,
VectorOutputEvaluator<Vector, Vector> {
    private MatrixMultiplyVectorFunction matrixMultiply;
    private VectorFunction squashingFunction;

    public SquashedMatrixMultiplyVectorFunction() {
        this(1, 1, (UnivariateScalarFunction)new AtanFunction());
    }

    public SquashedMatrixMultiplyVectorFunction(int numInputs, int numOutputs, UnivariateScalarFunction scalarFunction) {
        this(new MatrixMultiplyVectorFunction(numInputs, numOutputs), new ElementWiseVectorFunction(scalarFunction));
    }

    public SquashedMatrixMultiplyVectorFunction(MatrixMultiplyVectorFunction matrixMultiply, VectorFunction squashingFunction) {
        this.setMatrixMultiply(matrixMultiply);
        this.setSquashingFunction(squashingFunction);
    }

    public SquashedMatrixMultiplyVectorFunction(SquashedMatrixMultiplyVectorFunction other) {
        this(other.getMatrixMultiply().clone(), other.getSquashingFunction());
    }

    public MatrixMultiplyVectorFunction getMatrixMultiply() {
        return this.matrixMultiply;
    }

    public void setMatrixMultiply(MatrixMultiplyVectorFunction matrixMultiply) {
        this.matrixMultiply = matrixMultiply;
    }

    public VectorFunction getSquashingFunction() {
        return this.squashingFunction;
    }

    public void setSquashingFunction(VectorFunction squashingFunction) {
        this.squashingFunction = squashingFunction;
    }

    public Vector convertToVector() {
        return this.getMatrixMultiply().convertToVector();
    }

    public void convertFromVector(Vector parameters) {
        this.getMatrixMultiply().convertFromVector(parameters);
    }

    public Vector evaluate(Vector input) {
        return (Vector)this.squashingFunction.evaluate((Object)this.matrixMultiply.evaluate(input));
    }

    public SquashedMatrixMultiplyVectorFunction clone() {
        SquashedMatrixMultiplyVectorFunction clone = (SquashedMatrixMultiplyVectorFunction)super.clone();
        clone.setMatrixMultiply((MatrixMultiplyVectorFunction)ObjectUtil.cloneSafe((CloneableSerializable)this.getMatrixMultiply()));
        return clone;
    }

    public String toString() {
        String retval = "Squashing: " + this.getSquashingFunction().getClass() + "Weights:\n" + this.getMatrixMultiply().getInternalMatrix();
        return retval;
    }

    public int getInputDimensionality() {
        return this.getMatrixMultiply().getInputDimensionality();
    }

    public int getOutputDimensionality() {
        return this.getMatrixMultiply().getOutputDimensionality();
    }
}

