/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.parameter;

import gov.sandia.cognition.learning.algorithm.AbstractBatchLearnerContainer;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.parameter.ParameterAdaptable;
import gov.sandia.cognition.learning.parameter.ParameterAdapter;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.LinkedList;

public class ParameterAdaptableBatchLearnerWrapper<DataType, ResultType, LearnerType extends BatchLearner<? super DataType, ? extends ResultType>>
extends AbstractBatchLearnerContainer<LearnerType>
implements BatchLearner<DataType, ResultType>,
ParameterAdaptable<LearnerType, DataType> {
    protected LinkedList<ParameterAdapter<? super LearnerType, ? super DataType>> parameterAdapters;

    public ParameterAdaptableBatchLearnerWrapper() {
        this(null);
    }

    public ParameterAdaptableBatchLearnerWrapper(LearnerType learner) {
        super(learner);
        this.setParameterAdapters(null);
    }

    @Override
    public ParameterAdaptableBatchLearnerWrapper<DataType, ResultType, LearnerType> clone() {
        ParameterAdaptableBatchLearnerWrapper result = (ParameterAdaptableBatchLearnerWrapper)super.clone();
        result.parameterAdapters = ObjectUtil.cloneSmartElementsAsLinkedList(this.parameterAdapters);
        return result;
    }

    @Override
    public ResultType learn(DataType data) {
        if (this.parameterAdapters != null) {
            for (ParameterAdapter parameterAdapter : this.parameterAdapters) {
                parameterAdapter.adapt(this.getLearner(), data);
            }
        }
        return this.getLearner().learn(data);
    }

    @Override
    public void addParameterAdapter(ParameterAdapter<? super LearnerType, ? super DataType> parameterAdapter) {
        if (this.parameterAdapters == null) {
            this.parameterAdapters = new LinkedList();
        }
        this.parameterAdapters.add(parameterAdapter);
    }

    @Override
    public void removeParameterAdapter(ParameterAdapter<? super LearnerType, ? super DataType> parameterAdapter) {
        if (this.parameterAdapters != null) {
            this.parameterAdapters.remove(parameterAdapter);
            if (this.parameterAdapters.isEmpty()) {
                this.parameterAdapters = null;
            }
        }
    }

    @Override
    public LinkedList<ParameterAdapter<? super LearnerType, ? super DataType>> getParameterAdapters() {
        return this.parameterAdapters;
    }

    public void setParameterAdapters(LinkedList<ParameterAdapter<? super LearnerType, ? super DataType>> parameterAdapters) {
        this.parameterAdapters = parameterAdapters;
    }

    public static <DataType, ResultType, LearnerType extends BatchLearner<? super DataType, ? extends ResultType>> ParameterAdaptableBatchLearnerWrapper<DataType, ResultType, LearnerType> create(LearnerType learner) {
        return new ParameterAdaptableBatchLearnerWrapper<DataType, ResultType, LearnerType>(learner);
    }
}

