/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.learning.algorithm.AbstractBatchAndIncrementalLearner;
import gov.sandia.cognition.statistics.PointMassDistribution;
import gov.sandia.cognition.statistics.bayesian.ParticleFilter;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Random;

public abstract class AbstractParticleFilter<ObservationType, ParameterType>
extends AbstractBatchAndIncrementalLearner<ObservationType, PointMassDistribution<ParameterType>>
implements ParticleFilter<ObservationType, ParameterType> {
    protected ParticleFilter.Updater<ObservationType, ParameterType> updater;
    protected transient Random random;
    protected int numParticles;

    @Override
    public AbstractParticleFilter<ObservationType, ParameterType> clone() {
        AbstractParticleFilter clone = (AbstractParticleFilter)super.clone();
        clone.setUpdater((ParticleFilter.Updater)ObjectUtil.cloneSafe(this.getUpdater()));
        return clone;
    }

    @Override
    public ParticleFilter.Updater<ObservationType, ParameterType> getUpdater() {
        return this.updater;
    }

    public void setUpdater(ParticleFilter.Updater<ObservationType, ParameterType> updater) {
        this.updater = updater;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public PointMassDistribution<ParameterType> createInitialLearnedObject() {
        return this.getUpdater().createInitialParticles(this.getNumParticles());
    }

    @Override
    public double computeEffectiveParticles(PointMassDistribution<ParameterType> particles) {
        double totalMass = particles.getTotalMass();
        double sumSquared = 0.0;
        for (Object particle : particles.getDomain()) {
            double w = particles.getMass(particle) / totalMass;
            sumSquared += w * w;
        }
        return 1.0 / sumSquared;
    }

    @Override
    public int getNumParticles() {
        return this.numParticles;
    }

    @Override
    public void setNumParticles(int numParticles) {
        this.numParticles = numParticles;
    }
}

