/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.kernel.DefaultKernelContainer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.bayesian.BayesianEstimator;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;

@PublicationReferences(references={@PublicationReference(author={"Christopher M. Bishop"}, title="Pattern Recognition and Machine Learning", type=PublicationType.Book, year=2006, pages={303, 312}), @PublicationReference(author={"Hanna M. Wallach"}, title="Introduction to Gaussian Process Regression", type=PublicationType.Misc, year=2005, url="http://www.cs.umass.edu/~wallach/talks/gp_intro.pdf"), @PublicationReference(author={"Wikipedia"}, title="Kriging", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Kriging")})
public class GaussianProcessRegression<InputType>
extends DefaultKernelContainer<InputType>
implements BayesianEstimator<InputOutputPair<? extends InputType, Double>, Vector, MultivariateGaussian> {
    public static final double DEFAULT_MEASUREMENT_VARIANCE = 1.0;
    private double outputVariance;

    public GaussianProcessRegression() {
        this(null, 1.0);
    }

    public GaussianProcessRegression(Kernel<InputType> kernel, double outputVariance) {
        super(kernel);
        this.setOutputVariance(outputVariance);
    }

    @Override
    public GaussianProcessRegression<InputType> clone() {
        return (GaussianProcessRegression)super.clone();
    }

    @Override
    public MultivariateGaussian learn(Collection<? extends InputOutputPair<? extends InputType, Double>> data) {
        ArrayList dataArray = CollectionUtil.asArrayList(data);
        int N = dataArray.size();
        Matrix C = MatrixFactory.getDefault().createMatrix(N, N);
        Vector mean = VectorFactory.getDefault().createVector(N);
        for (int i = 0; i < N; ++i) {
            InputOutputPair pair = (InputOutputPair)dataArray.get(i);
            Object xi = pair.getInput();
            mean.setElement(i, ((Double)pair.getOutput()).doubleValue());
            for (int j = 0; j < N; ++j) {
                Object xj = ((InputOutputPair)dataArray.get(j)).getInput();
                double kv = this.kernel.evaluate(xi, xj);
                if (i == j) {
                    kv += this.getOutputVariance();
                }
                C.setElement(i, j, kv);
            }
        }
        return new MultivariateGaussian(mean, C);
    }

    public double getOutputVariance() {
        return this.outputVariance;
    }

    public void setOutputVariance(double outputVariance) {
        if (outputVariance < 0.0) {
            throw new IllegalArgumentException("Output variance must be >= 0.0");
        }
        this.outputVariance = outputVariance;
    }

    public PredictiveDistribution createPredictiveDistribution(MultivariateGaussian posterior, ArrayList<InputType> inputs) {
        return new PredictiveDistribution(posterior, inputs);
    }

    @PublicationReference(author={"Christopher M. Bishop"}, title="Pattern Recognition and Machine Learning", type=PublicationType.Book, year=2006, pages={308}, notes={"Equations 6.66 and 6.67"})
    public class PredictiveDistribution
    extends AbstractCloneableSerializable
    implements Evaluator<InputType, UnivariateGaussian> {
        private ArrayList<InputType> inputs;
        private MultivariateGaussian posterior;

        public PredictiveDistribution(MultivariateGaussian posterior, ArrayList<InputType> inputs) {
            this.posterior = posterior;
            this.inputs = inputs;
        }

        public UnivariateGaussian evaluate(InputType input) {
            int N = this.posterior.getInputDimensionality();
            Vector k = VectorFactory.getDefault().createVector(N);
            double c = GaussianProcessRegression.this.kernel.evaluate(input, input) + GaussianProcessRegression.this.getOutputVariance();
            for (int i = 0; i < N; ++i) {
                Object xi = this.inputs.get(i);
                k.setElement(i, GaussianProcessRegression.this.kernel.evaluate(xi, input));
            }
            Matrix Ci = this.posterior.getCovarianceInverse();
            Vector ktCi = k.times(Ci);
            double mean = ktCi.dotProduct(this.posterior.getMean());
            double variance = c - ktCi.dotProduct(k);
            return new UnivariateGaussian(mean, variance);
        }
    }
}

