/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.bayesian.AbstractMarkovChainMonteCarlo;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.WeightedValue;

@PublicationReference(author={"Wikipedia"}, title="Metropolis\u2013Hastings algorithm", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Metropolis-Hastings_algorithm")
public class MetropolisHastingsAlgorithm<ObservationType, ParameterType>
extends AbstractMarkovChainMonteCarlo<ObservationType, ParameterType>
implements MeasurablePerformanceAlgorithm {
    public static final String PERFORMANCE_NAME = "Current Log Likelihood";
    private double currentLogLikelihood;
    protected Updater<ObservationType, ParameterType> updater;

    public MetropolisHastingsAlgorithm() {
        this.setBurnInIterations(this.maxIterations / 10);
        this.setIterationsPerSample(this.maxIterations / 100);
    }

    @Override
    public MetropolisHastingsAlgorithm<ObservationType, ParameterType> clone() {
        MetropolisHastingsAlgorithm clone = (MetropolisHastingsAlgorithm)super.clone();
        clone.setUpdater((Updater)ObjectUtil.cloneSafe(this.getUpdater()));
        return clone;
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.currentLogLikelihood = Double.NEGATIVE_INFINITY;
        return super.initializeAlgorithm();
    }

    @Override
    protected void mcmcUpdate() {
        WeightedValue<Object> proposal = null;
        double proposalLogLikelihood = 0.0;
        boolean acceptProposal = false;
        while (!acceptProposal) {
            proposal = this.updater.makeProposal(this.currentParameter);
            proposalLogLikelihood = this.getUpdater().computeLogLikelihood(proposal.getValue(), (Iterable)this.data);
            if (Double.isInfinite(this.currentLogLikelihood)) {
                acceptProposal = true;
                break;
            }
            double pratio = Math.exp(proposalLogLikelihood - this.currentLogLikelihood);
            double qratio = proposal.getWeight();
            double a = qratio * pratio;
            if (a >= 1.0) {
                acceptProposal = true;
                continue;
            }
            double r = this.random.nextDouble();
            if (!(r <= a)) continue;
            acceptProposal = true;
        }
        this.currentParameter = proposal.getValue();
        this.currentLogLikelihood = proposalLogLikelihood;
    }

    public NamedValue<Double> getPerformance() {
        return new DefaultNamedValue(PERFORMANCE_NAME, (Object)this.currentLogLikelihood);
    }

    public Updater<ObservationType, ParameterType> getUpdater() {
        return this.updater;
    }

    public void setUpdater(Updater<ObservationType, ParameterType> updater) {
        this.updater = updater;
    }

    @Override
    public ParameterType createInitialLearnedObject() {
        return this.getUpdater().createInitialParameter();
    }

    public static interface Updater<ObservationType, ParameterType>
    extends CloneableSerializable {
        public ParameterType createInitialParameter();

        public double computeLogLikelihood(ParameterType var1, Iterable<? extends ObservationType> var2);

        public WeightedValue<ParameterType> makeProposal(ParameterType var1);
    }
}

