/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.conjugate.ConjugatePriorBayesianEstimatorPredictor;
import gov.sandia.cognition.statistics.distribution.NormalInverseGammaDistribution;
import gov.sandia.cognition.statistics.distribution.StudentTDistribution;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import java.util.ArrayList;
import java.util.Arrays;

@PublicationReferences(references={@PublicationReference(author={"Jeff Grynaviski"}, title="Bayesian Analysis of the Normal Distribution, Part II", type=PublicationType.Misc, year=2009, url="http://home.uchicago.edu/~grynav/bayes/ABSLec8.ppt"), @PublicationReference(author={"Wikipedia"}, title="Conjugate Prior", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Conjugate_prior")})
public class UnivariateGaussianMeanVarianceBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Double, Vector, UnivariateGaussian, NormalInverseGammaDistribution>
implements ConjugatePriorBayesianEstimatorPredictor<Double, Vector, UnivariateGaussian, NormalInverseGammaDistribution> {
    public UnivariateGaussianMeanVarianceBayesianEstimator() {
        this(new NormalInverseGammaDistribution());
    }

    public UnivariateGaussianMeanVarianceBayesianEstimator(NormalInverseGammaDistribution prior) {
        this(new UnivariateGaussian(), prior);
    }

    public UnivariateGaussianMeanVarianceBayesianEstimator(UnivariateGaussian conditional, NormalInverseGammaDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    protected UnivariateGaussianMeanVarianceBayesianEstimator(BayesianParameter<Vector, UnivariateGaussian, NormalInverseGammaDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(UnivariateGaussian conditional, NormalInverseGammaDistribution prior) {
        return new Parameter(conditional, prior);
    }

    @Override
    public void update(NormalInverseGammaDistribution target, Double data) {
        this.update(target, (Iterable<? extends Double>)Arrays.asList(data));
    }

    @Override
    public void update(NormalInverseGammaDistribution prior, Iterable<? extends Double> data) {
        ArrayList dataArray = CollectionUtil.asArrayList(data);
        int n = dataArray.size();
        double sum = 0.0;
        double sum2 = 0.0;
        for (Double d : data) {
            double v = d;
            sum += v;
            sum2 += v * v;
        }
        double sampleMean = sum / (double)n;
        double sampleVariance = ((double)n * sum2 - sum * sum) / (double)(n * n);
        double lambda = prior.getLocation();
        double nu = prior.getPrecision();
        double alpha = prior.getShape();
        double beta = prior.getScale();
        double alphahat = alpha + (double)n / 2.0;
        double nuhat = nu + (double)n;
        double lambdahat = (nu * lambda + sum) / nuhat;
        double delta = sampleMean - lambda;
        double betahat = beta + 0.5 * (double)n * sampleVariance + 0.5 * ((double)n * nu / nuhat) * (delta * delta);
        prior.setLocation(lambdahat);
        prior.setPrecision(nuhat);
        prior.setShape(alphahat);
        prior.setScale(betahat);
    }

    @Override
    public double computeEquivalentSampleSize(NormalInverseGammaDistribution belief) {
        return belief.getPrecision();
    }

    public StudentTDistribution createPredictiveDistribution(NormalInverseGammaDistribution posterior) {
        double mean = posterior.getLocation();
        double dofs = posterior.getPrecision();
        double precision = posterior.getShape() / posterior.getScale();
        return new StudentTDistribution(dofs, mean, precision);
    }

    public static class Parameter
    extends AbstractBayesianParameter<Vector, UnivariateGaussian, NormalInverseGammaDistribution> {
        public static final String NAME = "meanAndVariance";

        public Parameter(UnivariateGaussian conditional, NormalInverseGammaDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Vector value) {
            value.assertDimensionalityEquals(2);
            double mean = value.getElement(0);
            double variance = value.getElement(1);
            ((UnivariateGaussian)this.conditionalDistribution).setMean(mean);
            ((UnivariateGaussian)this.conditionalDistribution).setVariance(variance);
        }

        public Vector getValue() {
            return VectorFactory.getDefault().copyValues(new double[]{((UnivariateGaussian)this.conditionalDistribution).getMean(), ((UnivariateGaussian)this.conditionalDistribution).getVariance()});
        }
    }
}

