/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.IntegerCollection;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Mathworks"}, title="Geometric Distribution", type=PublicationType.WebPage, year=2010, url="http://www.mathworks.com/access/helpdesk/help/toolbox/stats/brn2ivz-58.html")
public class GeometricDistribution
extends AbstractClosedFormUnivariateDistribution<Number>
implements ClosedFormDiscreteUnivariateDistribution<Number>,
EstimableDistribution<Number, GeometricDistribution> {
    public static final double DEFAULT_P = 0.5;
    protected double p;

    public GeometricDistribution() {
        this(0.5);
    }

    public GeometricDistribution(double p) {
        this.setP(p);
    }

    public GeometricDistribution(GeometricDistribution other) {
        this(other.getP());
    }

    @Override
    public GeometricDistribution clone() {
        return (GeometricDistribution)super.clone();
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        ProbabilityUtil.assertIsProbability((double)p);
        this.p = p;
    }

    @Override
    public Double getMean() {
        return (1.0 - this.p) / this.p;
    }

    @Override
    public double getVariance() {
        return (1.0 - this.p) / (this.p * this.p);
    }

    @Override
    public ArrayList<Integer> sample(Random random, int numSamples) {
        double denom = Math.log(1.0 - this.p);
        ArrayList<Integer> samples = new ArrayList<Integer>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double lnu = Math.log(random.nextDouble());
            samples.add((int)Math.floor(lnu / denom));
        }
        return samples;
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getP()});
    }

    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.setP(parameters.getElement(0));
    }

    @Override
    public Integer getMinSupport() {
        return 0;
    }

    @Override
    public Integer getMaxSupport() {
        return Integer.MAX_VALUE;
    }

    public IntegerCollection getDomain() {
        double std = Math.sqrt(this.getVariance());
        int max = (int)Math.ceil(std * 10.0 + 10.0);
        return new IntegerCollection(this.getMinSupport().intValue(), max);
    }

    @Override
    public int getDomainSize() {
        return this.getDomain().size();
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Number, GeometricDistribution> {
        @Override
        public PMF learn(Collection<? extends Number> data) {
            double mean = UnivariateStatisticsUtil.computeMean(data);
            double p = 1.0 / (1.0 + mean);
            return new PMF(p);
        }
    }

    public static class CDF
    extends GeometricDistribution
    implements ClosedFormCumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(double p) {
            super(p);
        }

        public CDF(GeometricDistribution other) {
            super(other);
        }

        public Double evaluate(Number input) {
            int k = input.intValue();
            if (k < 0) {
                return 0.0;
            }
            return 1.0 - Math.pow(1.0 - this.p, k + 1);
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends GeometricDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(double p) {
            super(p);
        }

        public PMF(GeometricDistribution other) {
            super(other);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public double logEvaluate(Number input) {
            int k = input.intValue();
            if (k < 0) {
                return Math.log(0.0);
            }
            return (double)k * Math.log(1.0 - this.p) + Math.log(this.p);
        }

        public Double evaluate(Number input) {
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }
    }
}

