/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.PointMassDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.statistics.distribution.ScalarDataDistribution;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

public class MapBasedPointMassDistribution<DataType>
extends AbstractDistribution<DataType>
implements PointMassDistribution<DataType> {
    private double totalMass;
    private Map<DataType, Entry> dataMap;

    public MapBasedPointMassDistribution() {
        this.setDataMap(new LinkedHashMap());
        this.setTotalMass(0.0);
    }

    public MapBasedPointMassDistribution(int initialDomainCapacity) {
        this.setDataMap(new LinkedHashMap(initialDomainCapacity));
        this.setTotalMass(0.0);
    }

    public MapBasedPointMassDistribution(Collection<? extends DataType> values) {
        this(CollectionUtil.size(values));
        for (DataType value : values) {
            this.add(value);
        }
    }

    public MapBasedPointMassDistribution(MapBasedPointMassDistribution<DataType> other) {
        this(other.getDataMap().size());
        for (DataType value : other.getDomain()) {
            this.add(value, other.getMass(value));
        }
    }

    public MapBasedPointMassDistribution<DataType> clone() {
        MapBasedPointMassDistribution clone = (MapBasedPointMassDistribution)super.clone();
        clone.dataMap = new LinkedHashMap<DataType, Entry>(this.dataMap.size());
        for (Map.Entry<DataType, Entry> entry : this.dataMap.entrySet()) {
            clone.dataMap.put(entry.getKey(), new Entry(entry.getValue()));
        }
        return clone;
    }

    public DataType getMean() {
        Double mean = null;
        Object first = CollectionUtil.getFirst(this.getDomain());
        if (first instanceof Number) {
            mean = new Double(ScalarDataDistribution.getMean(this));
        } else if (first instanceof Ring) {
            RingAccumulator averager = new RingAccumulator();
            for (DataType value : this.getDomain()) {
                Ring ring = (Ring)value;
                averager.accumulate(ring.scale(this.getMass(value)));
            }
            mean = averager.scaleSum(1.0 / this.getTotalMass());
        } else {
            throw new UnsupportedOperationException("mean not supported");
        }
        return (DataType)mean;
    }

    @Override
    public ArrayList<DataType> sample(Random random, int numSamples) {
        return ProbabilityMassFunctionUtil.sample(this.getProbabilityFunction(), random, numSamples);
    }

    @Override
    public void add(DataType value) {
        this.add(value, 1.0);
    }

    @Override
    public void add(DataType value, double mass) {
        if (mass < 0.0) {
            throw new IllegalArgumentException("mass cannot be negative");
        }
        if (mass == 0.0) {
            return;
        }
        Entry entry = this.dataMap.get(value);
        if (entry == null) {
            entry = new Entry(mass);
            this.dataMap.put(value, entry);
        } else {
            entry.mass += mass;
        }
        this.totalMass += mass;
    }

    @Override
    public void setMass(DataType value, double mass) {
        if (mass < 0.0) {
            throw new IllegalArgumentException("mass cannot be negative");
        }
        double change = 0.0;
        Entry entry = this.dataMap.get(value);
        if (entry != null) {
            change = mass - entry.mass;
            entry.mass = mass;
            if (mass <= 0.0) {
                this.dataMap.remove(value);
            }
        } else if (mass > 0.0) {
            entry = new Entry(mass);
            this.dataMap.put(value, entry);
            change = mass;
        }
        this.totalMass += change;
    }

    @Override
    public void clear() {
        this.getDataMap().clear();
        this.setTotalMass(0.0);
    }

    @Override
    public void remove(DataType value) {
        this.remove(value, this.getMass(value));
    }

    @Override
    public void remove(DataType value, double mass) {
        if (mass < 0.0) {
            throw new IllegalArgumentException("mass cannot be negative");
        }
        if (mass == 0.0) {
            return;
        }
        Entry entry = this.dataMap.get(value);
        if (entry != null) {
            double currentMass = entry.mass;
            double newMass = currentMass - mass;
            if (newMass <= 0.0) {
                this.totalMass -= currentMass;
                this.dataMap.remove(value);
            } else {
                entry.mass = newMass;
                this.totalMass -= mass;
            }
        }
    }

    @Override
    public double getMass(DataType input) {
        Entry entry = this.dataMap.get(input);
        if (entry == null) {
            return 0.0;
        }
        return entry.mass;
    }

    public void plusEquals(PointMassDistribution<DataType> other) {
        for (Object value : other.getDomain()) {
            this.add(value, other.getMass(value));
        }
    }

    public void scaleEquals(double scaleFactor) {
        if (scaleFactor < 0.0) {
            throw new IllegalArgumentException("scaleFactor cannot be negative.");
        }
        for (Entry entry : this.dataMap.values()) {
            entry.mass *= scaleFactor;
        }
        this.totalMass *= scaleFactor;
    }

    public double getFraction(DataType input) {
        if (this.totalMass == 0.0) {
            return 0.0;
        }
        return this.getMass(input) / this.totalMass;
    }

    public double getMaximumMass() {
        double max = 0.0;
        for (Entry entry : this.dataMap.values()) {
            double mass = entry.mass;
            if (!(mass > max)) continue;
            max = mass;
        }
        return max;
    }

    public DataType getMaximumValue() {
        DataType value = null;
        double max = 0.0;
        for (Map.Entry<DataType, Entry> entry : this.dataMap.entrySet()) {
            double mass = entry.getValue().mass;
            if (!(mass > max)) continue;
            value = entry.getKey();
            max = mass;
        }
        return value;
    }

    public LinkedList<DataType> getMaximumValues() {
        return this.getMaximumValues(0.0);
    }

    public LinkedList<DataType> getMaximumValues(double effectiveZero) {
        double max = this.getMaximumMass() - effectiveZero;
        LinkedList<DataType> result = new LinkedList<DataType>();
        for (Map.Entry<DataType, Entry> entry : this.dataMap.entrySet()) {
            double mass = entry.getValue().mass;
            if (!(mass >= max)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public Collection<? extends DataType> getDomain() {
        return this.dataMap.keySet();
    }

    @Override
    public int getDomainSize() {
        return this.getDomain().size();
    }

    @Override
    public PMF<DataType> getProbabilityFunction() {
        return new PMF(this);
    }

    protected Map<DataType, Entry> getDataMap() {
        return this.dataMap;
    }

    protected void setDataMap(Map<DataType, Entry> dataMap) {
        this.dataMap = dataMap;
    }

    protected void setTotalMass(double totalMass) {
        this.totalMass = totalMass;
    }

    @Override
    public double getTotalMass() {
        return this.totalMass;
    }

    public String toString() {
        int N = this.getDomain().size();
        StringBuilder retval = new StringBuilder(N * 100);
        retval.append("Point mass distribution has " + N + " particles and " + this.getTotalMass() + " total mass:\n");
        for (DataType value : this.getDomain()) {
            retval.append(value.toString());
            retval.append(": ");
            retval.append(this.getMass(value));
            retval.append(" (");
            retval.append(this.getFraction(value));
            retval.append(")");
            retval.append("\n");
        }
        return retval.toString();
    }

    public static class Learner<DataType>
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<DataType, PMF<DataType>> {
        @Override
        public PMF<DataType> learn(Collection<? extends WeightedValue<? extends DataType>> data) {
            PMF<Object> retval = new PMF<Object>();
            for (WeightedValue<DataType> weightedValue : data) {
                retval.add(weightedValue.getValue(), weightedValue.getWeight());
            }
            return retval;
        }
    }

    public static class PMF<DataType>
    extends MapBasedPointMassDistribution<DataType>
    implements PointMassDistribution.PMF<DataType> {
        public PMF() {
        }

        public PMF(int initialCapacity) {
            super(initialCapacity);
        }

        public PMF(MapBasedPointMassDistribution<DataType> other) {
            super(other);
        }

        @Override
        public PMF<DataType> clone() {
            return (PMF)super.clone();
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        public Double evaluate(DataType input) {
            if (this.getTotalMass() > 0.0) {
                return this.getMass(input) / this.getTotalMass();
            }
            return 0.0;
        }

        @Override
        public double logEvaluate(DataType input) {
            return Math.log((Double)this.evaluate((Object)input));
        }

        @Override
        public PMF<DataType> getProbabilityFunction() {
            return this;
        }
    }

    protected static class Entry
    extends AbstractCloneableSerializable {
        protected double mass;

        protected Entry() {
            this(0.0);
        }

        protected Entry(double mass) {
            this.mass = mass;
        }

        protected Entry(Entry other) {
            this(other.mass);
        }

        protected double getMass() {
            return this.mass;
        }

        protected void setMass(double mass) {
            this.mass = mass;
        }
    }
}

