/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.distribution.ChiSquareDistribution;
import gov.sandia.cognition.statistics.distribution.SnedecorFDistribution;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.BlockExperimentComparison;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.WilcoxonSignedRankConfidence;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@ConfidenceTestAssumptions(name="Friedman's test", alsoKnownAs={""}, description={"Friedman's test determines if the rankings associated with various treatments are equal.", "This is a nonparametric rank-based alternative to ANOVA, a multiple comparison generalization similar to the difference between Student's t-test and Wilcoxon rank-signed test.", "Friedman's test tends to have as much power as ANOVA, but without ANOVA's parameteric assumptions"}, assumptions={"All data came from same distribution, without considering treatment effects.", "Measurements are independent and equivalent within a treatment.", "All observations are independent."}, nullHypothesis="The treatments have no effect on experimental observations.", dataPaired=true, dataSameSize=true, distribution=SnedecorFDistribution.class, reference={@PublicationReference(author={"Janez Demsar"}, title="Statistical Comparisons of Classifiers over Multiple Data Sets", type=PublicationType.Journal, publication="Journal of Machine Learning Research", year=2006, url="http://www.jmlr.org/papers/volume7/demsar06a/demsar06a.pdf"), @PublicationReference(author={"Wikipedia"}, title="Friedman test", type=PublicationType.WebPage, year=2011, url="http://en.wikipedia.org/wiki/Friedman_test", notes={"Our test uses the tighter F-statistic rather than the original chi-square statistic"})})
public class FriedmanConfidence
extends AbstractCloneableSerializable
implements BlockExperimentComparison<Number> {
    public static final FriedmanConfidence INSTANCE = new FriedmanConfidence();

    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        return this.evaluateNullHypothesis(Arrays.asList(data1, data2));
    }

    public Statistic evaluateNullHypothesis(Collection<? extends Collection<? extends Number>> data) {
        int K = data.size();
        int N = ((Collection)CollectionUtil.getFirst(data)).size();
        return new Statistic(K, N, FriedmanConfidence.computeTreatmentRankMeans(data));
    }

    public static ArrayList<Double> computeTreatmentRankMeans(Collection<? extends Collection<? extends Number>> data) {
        Object treatmentRanks;
        int K = data.size();
        int N = ((Collection)CollectionUtil.getFirst(data)).size();
        ArrayList dataTranspose = new ArrayList(N);
        for (int n = 0; n < N; ++n) {
            dataTranspose.add(new ArrayList(K));
        }
        ArrayList allRanks = new ArrayList(K);
        for (Collection<? extends Number> collection : data) {
            if (collection.size() != N) {
                throw new IllegalArgumentException("All treatments must be the same size!");
            }
            int n = 0;
            for (Number number : collection) {
                ((ArrayList)dataTranspose.get(n)).add(number.doubleValue());
                ++n;
            }
            allRanks.add(new ArrayList(N));
        }
        int n = 0;
        for (ArrayList arrayList : dataTranspose) {
            treatmentRanks = WilcoxonSignedRankConfidence.ranks(arrayList);
            for (int i = 0; i < K; ++i) {
                ((ArrayList)allRanks.get(i)).add(treatmentRanks[i]);
            }
            ++n;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(K);
        Iterator iterator = allRanks.iterator();
        while (iterator.hasNext()) {
            treatmentRanks = (ArrayList)iterator.next();
            double d = UnivariateStatisticsUtil.computeMean((Iterable)treatmentRanks);
            arrayList.add(d);
        }
        return arrayList;
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private int treatmentCount;
        private int subjectCount;
        private double chiSquare;
        private double degreesOfFreedom;
        private double chiSquareNullHypothesisProbability;
        private double F;
        private ArrayList<Double> treatmentRankMeans;

        public Statistic(int treatmentCount, int subjectCount, ArrayList<Double> treatmentRankMeans) {
            this(treatmentCount, subjectCount, treatmentRankMeans, Statistic.computeChiSquare(treatmentCount, subjectCount, treatmentRankMeans));
        }

        protected Statistic(int treatmentCount, int subjectCount, ArrayList<Double> treatmentRankMeans, double chiSquare) {
            this(treatmentCount, subjectCount, treatmentRankMeans, chiSquare, (double)(subjectCount - 1) * chiSquare / ((double)(subjectCount * (treatmentCount - 1)) - chiSquare));
        }

        protected Statistic(int treatmentCount, int subjectCount, ArrayList<Double> treatmentRankMeans, double chiSquare, double F) {
            super(1.0 - SnedecorFDistribution.CDF.evaluate(F, (double)treatmentCount - 1.0, ((double)treatmentCount - 1.0) * ((double)subjectCount - 1.0)));
            this.treatmentCount = treatmentCount;
            this.subjectCount = subjectCount;
            this.treatmentRankMeans = treatmentRankMeans;
            this.chiSquare = chiSquare;
            this.degreesOfFreedom = (double)treatmentCount - 1.0;
            this.chiSquareNullHypothesisProbability = 1.0 - ChiSquareDistribution.CDF.evaluate(chiSquare, (double)treatmentCount - 1.0);
            this.F = F;
        }

        protected static double computeChiSquare(int treatmentCount, int subjectCount, ArrayList<Double> treatmentRankMeans) {
            double rankMean = UnivariateStatisticsUtil.computeMean(treatmentRankMeans);
            double treatmentSumSquared = (double)subjectCount * UnivariateStatisticsUtil.computeSumSquaredDifference(treatmentRankMeans, (double)rankMean);
            double chiSquare = treatmentSumSquared / ((double)treatmentCount * ((double)treatmentCount + 1.0) / 12.0);
            return chiSquare;
        }

        public Statistic clone() {
            Statistic clone = (Statistic)super.clone();
            clone.treatmentRankMeans = ObjectUtil.cloneSmartElementsAsArrayList(this.getTreatmentRankMeans());
            return clone;
        }

        public int getTreatmentCount() {
            return this.treatmentCount;
        }

        public int getSubjectCount() {
            return this.subjectCount;
        }

        public double getChiSquare() {
            return this.chiSquare;
        }

        public ArrayList<Double> getTreatmentRankMeans() {
            return this.treatmentRankMeans;
        }

        public double getDegreesOfFreedom() {
            return this.degreesOfFreedom;
        }

        public double getChiSquareNullHypothesisProbability() {
            return this.chiSquareNullHypothesisProbability;
        }

        public double getF() {
            return this.F;
        }

        @Override
        public double getTestStatistic() {
            return this.getF();
        }
    }
}

