/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.statistics.method.BlockExperimentComparison;
import gov.sandia.cognition.statistics.method.ConfidenceStatistic;
import gov.sandia.cognition.statistics.method.FriedmanConfidence;
import gov.sandia.cognition.statistics.method.MultipleHypothesisComparison;
import gov.sandia.cognition.statistics.method.NemenyiConfidence;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Arrays;
import java.util.Collection;

public class MultipleComparisonExperiment
extends AbstractCloneableSerializable
implements BlockExperimentComparison<Number>,
MultipleHypothesisComparison<Collection<? extends Number>> {
    public static final BlockExperimentComparison<Number> DEFAULT_BLOCK_EXPERIMENT_COMPARISON = FriedmanConfidence.INSTANCE;
    public static final MultipleHypothesisComparison<Collection<? extends Number>> DEFAULT_POST_HOC_TEST = NemenyiConfidence.INSTANCE;
    public static final double DEFAULT_ALPHA = 0.05;
    private BlockExperimentComparison<Number> blockExperimentComparison;
    private MultipleHypothesisComparison<Collection<? extends Number>> postHocTest;
    private double alpha;

    public MultipleComparisonExperiment() {
        this(DEFAULT_BLOCK_EXPERIMENT_COMPARISON, DEFAULT_POST_HOC_TEST, 0.05);
    }

    public MultipleComparisonExperiment(BlockExperimentComparison<Number> blockExperimentComparison, MultipleHypothesisComparison<Collection<? extends Number>> postHocTest, double alpha) {
        this.setBlockExperimentComparison(blockExperimentComparison);
        this.setPostHocTest(postHocTest);
        this.setAlpha(alpha);
    }

    public MultipleComparisonExperiment clone() {
        MultipleComparisonExperiment clone = (MultipleComparisonExperiment)super.clone();
        clone.setBlockExperimentComparison((BlockExperimentComparison)ObjectUtil.cloneSafe(this.getBlockExperimentComparison()));
        clone.setPostHocTest((MultipleHypothesisComparison)ObjectUtil.cloneSafe(this.getPostHocTest()));
        return clone;
    }

    public BlockExperimentComparison<Number> getBlockExperimentComparison() {
        return this.blockExperimentComparison;
    }

    public void setBlockExperimentComparison(BlockExperimentComparison<Number> blockExperimentComparison) {
        this.blockExperimentComparison = blockExperimentComparison;
    }

    public MultipleHypothesisComparison<Collection<? extends Number>> getPostHocTest() {
        return this.postHocTest;
    }

    public void setPostHocTest(MultipleHypothesisComparison<Collection<? extends Number>> postHocTest) {
        this.postHocTest = postHocTest;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public Statistic evaluateNullHypothesis(Collection<? extends Collection<? extends Number>> treatments) {
        ConfidenceStatistic blockExperimentResult = this.getBlockExperimentComparison().evaluateNullHypothesis(treatments);
        MultipleHypothesisComparison.Statistic multipleComparisonResult = null;
        if (blockExperimentResult.getNullHypothesisProbability() < this.getAlpha()) {
            multipleComparisonResult = this.getPostHocTest().evaluateNullHypotheses(treatments, this.getAlpha());
        }
        return new Statistic(blockExperimentResult, multipleComparisonResult);
    }

    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        return this.evaluateNullHypothesis(Arrays.asList(data1, data2));
    }

    public Statistic evaluateNullHypotheses(Collection<? extends Collection<? extends Number>> data) {
        return this.evaluateNullHypothesis((Collection)data);
    }

    public Statistic evaluateNullHypotheses(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha) {
        this.setAlpha(uncompensatedAlpha);
        return this.evaluateNullHypotheses((Collection)data);
    }

    public static class Statistic
    extends AbstractCloneableSerializable
    implements ConfidenceStatistic,
    MultipleHypothesisComparison.Statistic {
        protected ConfidenceStatistic blockExperimentResult;
        protected MultipleHypothesisComparison.Statistic multipleComparisonResult;

        public Statistic(ConfidenceStatistic blockExperimentResult, MultipleHypothesisComparison.Statistic multipleComparisonResult) {
            this.blockExperimentResult = blockExperimentResult;
            this.multipleComparisonResult = multipleComparisonResult;
        }

        @Override
        public double getTestStatistic() {
            return this.blockExperimentResult.getTestStatistic();
        }

        @Override
        public int getTreatmentCount() {
            if (this.multipleComparisonResult != null) {
                return this.multipleComparisonResult.getTreatmentCount();
            }
            return 0;
        }

        @Override
        public double getUncompensatedAlpha() {
            if (this.multipleComparisonResult != null) {
                return this.multipleComparisonResult.getUncompensatedAlpha();
            }
            return 0.0;
        }

        @Override
        public double getTestStatistic(int i, int j) {
            if (this.multipleComparisonResult != null) {
                return this.multipleComparisonResult.getTestStatistic(i, j);
            }
            return Double.NaN;
        }

        @Override
        public double getNullHypothesisProbability(int i, int j) {
            if (this.multipleComparisonResult != null) {
                return this.multipleComparisonResult.getNullHypothesisProbability(i, j);
            }
            return 1.0;
        }

        @Override
        public boolean acceptNullHypothesis(int i, int j) {
            if (this.multipleComparisonResult != null) {
                return this.multipleComparisonResult.acceptNullHypothesis(i, j);
            }
            return true;
        }

        @Override
        public double getNullHypothesisProbability() {
            return this.blockExperimentResult.getNullHypothesisProbability();
        }

        public ConfidenceStatistic getBlockExperimentResult() {
            return this.blockExperimentResult;
        }

        public MultipleHypothesisComparison.Statistic getMultipleComparisonResult() {
            return this.multipleComparisonResult;
        }

        public String toString() {
            return ObjectUtil.toString((Object)this);
        }
    }
}

