/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.montecarlo;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.statistics.montecarlo.MonteCarloIntegrator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultivariateMonteCarloIntegrator
extends AbstractCloneableSerializable
implements MonteCarloIntegrator<Vector> {
    public static final double DEFAULT_VARIANCE = 0.0;
    public static final MultivariateMonteCarloIntegrator INSTANCE = new MultivariateMonteCarloIntegrator();

    public <SampleType> MultivariateGaussian.PDF integrate(Collection<? extends SampleType> samples, Evaluator<? super SampleType, ? extends Vector> expectationFunction) {
        ArrayList<Vector> outputs = new ArrayList<Vector>(samples.size());
        for (SampleType sample : samples) {
            outputs.add(((Vector)expectationFunction.evaluate(sample)).convertToVector());
        }
        return MultivariateGaussian.MaximumLikelihoodEstimator.learn(outputs, 0.0);
    }

    public <SampleType> MultivariateGaussian.PDF integrate(List<? extends WeightedValue<? extends SampleType>> samples, Evaluator<? super SampleType, ? extends Vector> expectationFunction) {
        ArrayList<DefaultWeightedValue> outputs = new ArrayList<DefaultWeightedValue>(samples.size());
        for (WeightedValue<SampleType> weightedValue : samples) {
            Vector output = ((Vector)expectationFunction.evaluate(weightedValue.getValue())).convertToVector();
            outputs.add(new DefaultWeightedValue((Object)output, weightedValue.getWeight()));
        }
        return MultivariateGaussian.WeightedMaximumLikelihoodEstimator.learn(outputs, 0.0);
    }

    public MultivariateGaussian.PDF getMean(Collection<? extends Vector> samples) {
        MultivariateGaussian.PDF pdf = MultivariateGaussian.MaximumLikelihoodEstimator.learn(samples, 0.0);
        Matrix C = (Matrix)pdf.getCovariance().scale(1.0 / (double)samples.size());
        pdf.setCovariance(C);
        return pdf;
    }

    public MultivariateGaussian.PDF getMean(List<? extends WeightedValue<? extends Vector>> samples) {
        MultivariateGaussian.PDF pdf = MultivariateGaussian.WeightedMaximumLikelihoodEstimator.learn(samples, 0.0);
        double weightSum = 0.0;
        double sumSquared = 0.0;
        for (WeightedValue<? extends Vector> weightedValue : samples) {
            double w = weightedValue.getWeight();
            weightSum += w;
            sumSquared += w * w;
        }
        double ws2 = weightSum * weightSum;
        Matrix C = (Matrix)pdf.getCovariance().scale(sumSquared / ws2);
        pdf.setCovariance(C);
        return pdf;
    }
}

