/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.UncheckedException;

public class GradleVersion
implements Comparable<GradleVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\d+)(\\.\\d+)+)(-(\\p{Alpha}+)-(\\w+))?(-(SNAPSHOT|\\d{14}([-+]\\d{4})?))?");
    private static final int STAGE_MILESTONE = 0;
    private static final int STAGE_UNKNOWN = 1;
    private static final int STAGE_PREVIEW = 2;
    private static final int STAGE_RC = 3;
    private final String version;
    private final int majorPart;
    private final Long snapshot;
    private final String versionPart;
    private final Stage stage;

    public static GradleVersion version(String version) throws IllegalArgumentException {
        return new GradleVersion(version);
    }

    private GradleVersion(String version) {
        this.version = version;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Gradle version string (examples: '1.0', '1.0-rc-1')", version));
        }
        this.versionPart = matcher.group(1);
        this.majorPart = Integer.parseInt(matcher.group(2), 10);
        this.stage = this.parseStage(matcher);
        this.snapshot = this.parseSnapshot(matcher);
    }

    private Long parseSnapshot(Matcher matcher) {
        if ("snapshot".equals(matcher.group(5)) || this.isCommitVersion(matcher)) {
            return 0L;
        }
        if (matcher.group(8) == null) {
            return null;
        }
        if ("SNAPSHOT".equals(matcher.group(8))) {
            return 0L;
        }
        try {
            if (matcher.group(9) != null) {
                return new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(8)).getTime();
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format.parse(matcher.group(8)).getTime();
        }
        catch (ParseException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Stage parseStage(Matcher matcher) {
        if (matcher.group(4) == null || this.isCommitVersion(matcher)) {
            return null;
        }
        if (this.isStage("milestone", matcher)) {
            return Stage.from(0, matcher.group(6));
        }
        if (this.isStage("preview", matcher)) {
            return Stage.from(2, matcher.group(6));
        }
        if (this.isStage("rc", matcher)) {
            return Stage.from(3, matcher.group(6));
        }
        return Stage.from(1, matcher.group(6));
    }

    private boolean isCommitVersion(Matcher matcher) {
        return "commit".equals(matcher.group(5));
    }

    private boolean isStage(String stage, Matcher matcher) {
        return stage.equals(matcher.group(5));
    }

    private String setOrParseCommitId(String commitId, Matcher matcher) {
        if (commitId != null || !this.isCommitVersion(matcher)) {
            return commitId;
        }
        return matcher.group(6);
    }

    public String toString() {
        return "Gradle " + this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    public GradleVersion getBaseVersion() {
        if (this.stage == null && this.snapshot == null) {
            return this;
        }
        return GradleVersion.version(this.versionPart);
    }

    public GradleVersion getNextMajor() {
        return GradleVersion.version(this.majorPart + 1 + ".0");
    }

    @Override
    public int compareTo(GradleVersion gradleVersion) {
        Long theirSnapshot;
        int diff;
        String[] majorVersionParts = this.versionPart.split("\\.");
        String[] otherMajorVersionParts = gradleVersion.versionPart.split("\\.");
        for (int i = 0; i < majorVersionParts.length && i < otherMajorVersionParts.length; ++i) {
            int otherPart;
            int part = Integer.parseInt(majorVersionParts[i]);
            if (part > (otherPart = Integer.parseInt(otherMajorVersionParts[i]))) {
                return 1;
            }
            if (otherPart <= part) continue;
            return -1;
        }
        if (majorVersionParts.length > otherMajorVersionParts.length) {
            return 1;
        }
        if (majorVersionParts.length < otherMajorVersionParts.length) {
            return -1;
        }
        if (this.stage != null && gradleVersion.stage != null && (diff = this.stage.compareTo(gradleVersion.stage)) != 0) {
            return diff;
        }
        if (this.stage == null && gradleVersion.stage != null) {
            return 1;
        }
        if (this.stage != null && gradleVersion.stage == null) {
            return -1;
        }
        Long thisSnapshot = this.snapshot == null ? Long.MAX_VALUE : this.snapshot;
        if (thisSnapshot.equals(theirSnapshot = Long.valueOf(gradleVersion.snapshot == null ? Long.MAX_VALUE : gradleVersion.snapshot))) {
            return this.version.compareTo(gradleVersion.version);
        }
        return thisSnapshot.compareTo(theirSnapshot);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GradleVersion other = (GradleVersion)o;
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean isValid() {
        return this.versionPart != null;
    }

    static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;
        final Character patchNo;

        private Stage(int stage, int number, Character patchNo) {
            this.stage = stage;
            this.number = number;
            this.patchNo = patchNo;
        }

        static Stage from(int stage, String stageString) {
            Matcher m = Pattern.compile("(\\d+)([a-z])?").matcher(stageString);
            if (!m.matches()) {
                return null;
            }
            int number = Integer.parseInt(m.group(1));
            if (m.groupCount() == 2 && m.group(2) != null) {
                return new Stage(stage, number, Character.valueOf(m.group(2).charAt(0)));
            }
            return new Stage(stage, number, Character.valueOf('_'));
        }

        @Override
        public int compareTo(Stage other) {
            if (this.stage > other.stage) {
                return 1;
            }
            if (this.stage < other.stage) {
                return -1;
            }
            if (this.number > other.number) {
                return 1;
            }
            if (this.number < other.number) {
                return -1;
            }
            if (this.patchNo.charValue() > other.patchNo.charValue()) {
                return 1;
            }
            if (this.patchNo.charValue() < other.patchNo.charValue()) {
                return -1;
            }
            return 0;
        }
    }
}

