/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.continuous.run;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import ratpack.gradle.internal.Invoker;

public class RatpackServerProxy {
    public static final String CAPTURER_CLASS_NAME = "ratpack.server.internal.ServerCapturer";
    public static final String BLOCK_CLASS_NAME = "ratpack.func.Block";
    public static final String SERVER_INTERFACE_NAME = "ratpack.server.RatpackServer";
    private final Object server;
    private final ClassLoader classLoader;

    public RatpackServerProxy(Object server, ClassLoader classLoader) {
        this.server = server;
        this.classLoader = classLoader;
    }

    public void stop() {
        try {
            Invoker.invokeParamless(this.classLoader.loadClass(SERVER_INTERFACE_NAME), this.server, "stop");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop server", e);
        }
    }

    public static RatpackServerProxy capture(ClassLoader classLoader, final String mainClassName, final String[] appArgs) {
        Object server;
        Method captureMethod;
        Method main;
        Class<?> mainClass;
        try {
            mainClass = classLoader.loadClass(mainClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Did not find specified main class: " + mainClassName, e);
        }
        try {
            main = mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Did not find main(String...) method on main class: " + mainClassName, e);
        }
        if (!Modifier.isStatic(main.getModifiers())) {
            throw new RuntimeException("main(String...) is not static on class: " + mainClassName);
        }
        Class<?> capturer = RatpackServerProxy.loadClass(classLoader, CAPTURER_CLASS_NAME);
        Class<?> blockType = RatpackServerProxy.loadClass(classLoader, BLOCK_CLASS_NAME);
        Class<?> serverType = RatpackServerProxy.loadClass(classLoader, SERVER_INTERFACE_NAME);
        try {
            captureMethod = capturer.getMethod("capture", blockType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find capture() on ServerCapturer", e);
        }
        final Method finalMain = main;
        Object block = Proxy.newProxyInstance(classLoader, new Class[]{blockType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    finalMain.invoke(null, new Object[]{appArgs});
                }
                catch (Exception e) {
                    throw new RuntimeException("failed to invoke main(String...) on class: " + mainClassName, e);
                }
                return null;
            }
        });
        try {
            server = captureMethod.invoke(null, block);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke get() on ServerCapturer", e);
        }
        if (server == null) {
            throw new RuntimeException("main(String...) of " + mainClassName + " did not start a Ratpack server");
        }
        if (!serverType.isAssignableFrom(server.getClass())) {
            throw new RuntimeException("Captured " + server.getClass().getName() + ", not a " + SERVER_INTERFACE_NAME);
        }
        return new RatpackServerProxy(server, classLoader);
    }

    private static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load " + className, e);
        }
    }

    public boolean isRunning() {
        try {
            return (Boolean)this.server.getClass().getMethod("isRunning", new Class[0]).invoke(this.server, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke isRunning on server", e);
        }
    }
}

