/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.CommunicationRequestPayload;
import org.hl7.fhir.CommunicationRequestStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CommunicationRequest", propOrder={"identifier", "category", "sender", "recipient", "payload", "medium", "requester", "status", "encounter", "scheduledDateTime", "scheduledPeriod", "reason", "requestedOn", "subject", "priority"})
public class CommunicationRequest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected CodeableConcept category;
    protected Reference sender;
    protected List<Reference> recipient;
    protected List<CommunicationRequestPayload> payload;
    protected List<CodeableConcept> medium;
    protected Reference requester;
    protected CommunicationRequestStatus status;
    protected Reference encounter;
    protected DateTime scheduledDateTime;
    protected Period scheduledPeriod;
    protected List<CodeableConcept> reason;
    protected DateTime requestedOn;
    protected Reference subject;
    protected CodeableConcept priority;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public Reference getSender() {
        return this.sender;
    }

    public void setSender(Reference value) {
        this.sender = value;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public List<CommunicationRequestPayload> getPayload() {
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationRequestPayload>();
        }
        return this.payload;
    }

    public List<CodeableConcept> getMedium() {
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        return this.medium;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public void setRequester(Reference value) {
        this.requester = value;
    }

    public CommunicationRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommunicationRequestStatus value) {
        this.status = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getScheduledDateTime() {
        return this.scheduledDateTime;
    }

    public void setScheduledDateTime(DateTime value) {
        this.scheduledDateTime = value;
    }

    public Period getScheduledPeriod() {
        return this.scheduledPeriod;
    }

    public void setScheduledPeriod(Period value) {
        this.scheduledPeriod = value;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public DateTime getRequestedOn() {
        return this.requestedOn;
    }

    public void setRequestedOn(DateTime value) {
        this.requestedOn = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public void setPriority(CodeableConcept value) {
        this.priority = value;
    }

    public CommunicationRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public CommunicationRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public CommunicationRequest withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public CommunicationRequest withSender(Reference value) {
        this.setSender(value);
        return this;
    }

    public CommunicationRequest withRecipient(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getRecipient().add(value);
            }
        }
        return this;
    }

    public CommunicationRequest withRecipient(Collection<Reference> values) {
        if (values != null) {
            this.getRecipient().addAll(values);
        }
        return this;
    }

    public CommunicationRequest withPayload(CommunicationRequestPayload ... values) {
        if (values != null) {
            for (CommunicationRequestPayload value : values) {
                this.getPayload().add(value);
            }
        }
        return this;
    }

    public CommunicationRequest withPayload(Collection<CommunicationRequestPayload> values) {
        if (values != null) {
            this.getPayload().addAll(values);
        }
        return this;
    }

    public CommunicationRequest withMedium(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getMedium().add(value);
            }
        }
        return this;
    }

    public CommunicationRequest withMedium(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getMedium().addAll(values);
        }
        return this;
    }

    public CommunicationRequest withRequester(Reference value) {
        this.setRequester(value);
        return this;
    }

    public CommunicationRequest withStatus(CommunicationRequestStatus value) {
        this.setStatus(value);
        return this;
    }

    public CommunicationRequest withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public CommunicationRequest withScheduledDateTime(DateTime value) {
        this.setScheduledDateTime(value);
        return this;
    }

    public CommunicationRequest withScheduledPeriod(Period value) {
        this.setScheduledPeriod(value);
        return this;
    }

    public CommunicationRequest withReason(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReason().add(value);
            }
        }
        return this;
    }

    public CommunicationRequest withReason(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReason().addAll(values);
        }
        return this;
    }

    public CommunicationRequest withRequestedOn(DateTime value) {
        this.setRequestedOn(value);
        return this;
    }

    public CommunicationRequest withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public CommunicationRequest withPriority(CodeableConcept value) {
        this.setPriority(value);
        return this;
    }

    @Override
    public CommunicationRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public CommunicationRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public CommunicationRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public CommunicationRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CommunicationRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CommunicationRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CommunicationRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CommunicationRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public CommunicationRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public CommunicationRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public CommunicationRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CommunicationRequest that = (CommunicationRequest)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        Reference lhsSender = this.getSender();
        Reference rhsSender = that.getSender();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sender", (Object)lhsSender), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sender", (Object)rhsSender), (Object)lhsSender, (Object)rhsSender, this.sender != null, that.sender != null)) {
            return false;
        }
        List<Reference> lhsRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        List<Reference> rhsRecipient = that.recipient != null && !that.recipient.isEmpty() ? that.getRecipient() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"recipient", lhsRecipient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"recipient", rhsRecipient), lhsRecipient, rhsRecipient, this.recipient != null && !this.recipient.isEmpty(), that.recipient != null && !that.recipient.isEmpty())) {
            return false;
        }
        List<CommunicationRequestPayload> lhsPayload = this.payload != null && !this.payload.isEmpty() ? this.getPayload() : null;
        List<CommunicationRequestPayload> rhsPayload = that.payload != null && !that.payload.isEmpty() ? that.getPayload() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"payload", lhsPayload), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"payload", rhsPayload), lhsPayload, rhsPayload, this.payload != null && !this.payload.isEmpty(), that.payload != null && !that.payload.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsMedium = this.medium != null && !this.medium.isEmpty() ? this.getMedium() : null;
        List<CodeableConcept> rhsMedium = that.medium != null && !that.medium.isEmpty() ? that.getMedium() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medium", lhsMedium), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medium", rhsMedium), lhsMedium, rhsMedium, this.medium != null && !this.medium.isEmpty(), that.medium != null && !that.medium.isEmpty())) {
            return false;
        }
        Reference lhsRequester = this.getRequester();
        Reference rhsRequester = that.getRequester();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"requester", (Object)lhsRequester), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"requester", (Object)rhsRequester), (Object)lhsRequester, (Object)rhsRequester, this.requester != null, that.requester != null)) {
            return false;
        }
        CommunicationRequestStatus lhsStatus = this.getStatus();
        CommunicationRequestStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        DateTime lhsScheduledDateTime = this.getScheduledDateTime();
        DateTime rhsScheduledDateTime = that.getScheduledDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"scheduledDateTime", (Object)lhsScheduledDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"scheduledDateTime", (Object)rhsScheduledDateTime), (Object)lhsScheduledDateTime, (Object)rhsScheduledDateTime, this.scheduledDateTime != null, that.scheduledDateTime != null)) {
            return false;
        }
        Period lhsScheduledPeriod = this.getScheduledPeriod();
        Period rhsScheduledPeriod = that.getScheduledPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"scheduledPeriod", (Object)lhsScheduledPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"scheduledPeriod", (Object)rhsScheduledPeriod), (Object)lhsScheduledPeriod, (Object)rhsScheduledPeriod, this.scheduledPeriod != null, that.scheduledPeriod != null)) {
            return false;
        }
        List<CodeableConcept> lhsReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        List<CodeableConcept> rhsReason = that.reason != null && !that.reason.isEmpty() ? that.getReason() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reason", lhsReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reason", rhsReason), lhsReason, rhsReason, this.reason != null && !this.reason.isEmpty(), that.reason != null && !that.reason.isEmpty())) {
            return false;
        }
        DateTime lhsRequestedOn = this.getRequestedOn();
        DateTime rhsRequestedOn = that.getRequestedOn();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"requestedOn", (Object)lhsRequestedOn), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"requestedOn", (Object)rhsRequestedOn), (Object)lhsRequestedOn, (Object)rhsRequestedOn, this.requestedOn != null, that.requestedOn != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        CodeableConcept lhsPriority = this.getPriority();
        CodeableConcept rhsPriority = that.getPriority();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"priority", (Object)lhsPriority), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"priority", (Object)rhsPriority), (Object)lhsPriority, (Object)rhsPriority, this.priority != null, that.priority != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"category", (Object)theCategory), currentHashCode, (Object)theCategory, this.category != null);
        Reference theSender = this.getSender();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sender", (Object)theSender), currentHashCode, (Object)theSender, this.sender != null);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"recipient", theRecipient), currentHashCode, theRecipient, this.recipient != null && !this.recipient.isEmpty());
        List<CommunicationRequestPayload> thePayload = this.payload != null && !this.payload.isEmpty() ? this.getPayload() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"payload", thePayload), currentHashCode, thePayload, this.payload != null && !this.payload.isEmpty());
        List<CodeableConcept> theMedium = this.medium != null && !this.medium.isEmpty() ? this.getMedium() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medium", theMedium), currentHashCode, theMedium, this.medium != null && !this.medium.isEmpty());
        Reference theRequester = this.getRequester();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"requester", (Object)theRequester), currentHashCode, (Object)theRequester, this.requester != null);
        CommunicationRequestStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter, this.encounter != null);
        DateTime theScheduledDateTime = this.getScheduledDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"scheduledDateTime", (Object)theScheduledDateTime), currentHashCode, (Object)theScheduledDateTime, this.scheduledDateTime != null);
        Period theScheduledPeriod = this.getScheduledPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"scheduledPeriod", (Object)theScheduledPeriod), currentHashCode, (Object)theScheduledPeriod, this.scheduledPeriod != null);
        List<CodeableConcept> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reason", theReason), currentHashCode, theReason, this.reason != null && !this.reason.isEmpty());
        DateTime theRequestedOn = this.getRequestedOn();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"requestedOn", (Object)theRequestedOn), currentHashCode, (Object)theRequestedOn, this.requestedOn != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject, this.subject != null);
        CodeableConcept thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"priority", (Object)thePriority), currentHashCode, (Object)thePriority, this.priority != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory, this.category != null);
        Reference theSender = this.getSender();
        strategy.appendField(locator, (Object)this, "sender", buffer, (Object)theSender, this.sender != null);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        strategy.appendField(locator, (Object)this, "recipient", buffer, theRecipient, this.recipient != null && !this.recipient.isEmpty());
        List<CommunicationRequestPayload> thePayload = this.payload != null && !this.payload.isEmpty() ? this.getPayload() : null;
        strategy.appendField(locator, (Object)this, "payload", buffer, thePayload, this.payload != null && !this.payload.isEmpty());
        List<CodeableConcept> theMedium = this.medium != null && !this.medium.isEmpty() ? this.getMedium() : null;
        strategy.appendField(locator, (Object)this, "medium", buffer, theMedium, this.medium != null && !this.medium.isEmpty());
        Reference theRequester = this.getRequester();
        strategy.appendField(locator, (Object)this, "requester", buffer, (Object)theRequester, this.requester != null);
        CommunicationRequestStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter, this.encounter != null);
        DateTime theScheduledDateTime = this.getScheduledDateTime();
        strategy.appendField(locator, (Object)this, "scheduledDateTime", buffer, (Object)theScheduledDateTime, this.scheduledDateTime != null);
        Period theScheduledPeriod = this.getScheduledPeriod();
        strategy.appendField(locator, (Object)this, "scheduledPeriod", buffer, (Object)theScheduledPeriod, this.scheduledPeriod != null);
        List<CodeableConcept> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        strategy.appendField(locator, (Object)this, "reason", buffer, theReason, this.reason != null && !this.reason.isEmpty());
        DateTime theRequestedOn = this.getRequestedOn();
        strategy.appendField(locator, (Object)this, "requestedOn", buffer, (Object)theRequestedOn, this.requestedOn != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject, this.subject != null);
        CodeableConcept thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, (Object)thePriority, this.priority != null);
        return buffer;
    }
}

