/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.DataRequirement;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.ModuleMetadata;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ParameterDefinition;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.TriggerDefinition;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DecisionSupportServiceModule", propOrder={"moduleMetadata", "trigger", "parameter", "dataRequirement"})
public class DecisionSupportServiceModule
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected ModuleMetadata moduleMetadata;
    protected List<TriggerDefinition> trigger;
    protected List<ParameterDefinition> parameter;
    protected List<DataRequirement> dataRequirement;

    public ModuleMetadata getModuleMetadata() {
        return this.moduleMetadata;
    }

    public void setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
    }

    public List<TriggerDefinition> getTrigger() {
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        return this.trigger;
    }

    public List<ParameterDefinition> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        return this.parameter;
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public DecisionSupportServiceModule withModuleMetadata(ModuleMetadata value) {
        this.setModuleMetadata(value);
        return this;
    }

    public DecisionSupportServiceModule withTrigger(TriggerDefinition ... values) {
        if (values != null) {
            for (TriggerDefinition value : values) {
                this.getTrigger().add(value);
            }
        }
        return this;
    }

    public DecisionSupportServiceModule withTrigger(Collection<TriggerDefinition> values) {
        if (values != null) {
            this.getTrigger().addAll(values);
        }
        return this;
    }

    public DecisionSupportServiceModule withParameter(ParameterDefinition ... values) {
        if (values != null) {
            for (ParameterDefinition value : values) {
                this.getParameter().add(value);
            }
        }
        return this;
    }

    public DecisionSupportServiceModule withParameter(Collection<ParameterDefinition> values) {
        if (values != null) {
            this.getParameter().addAll(values);
        }
        return this;
    }

    public DecisionSupportServiceModule withDataRequirement(DataRequirement ... values) {
        if (values != null) {
            for (DataRequirement value : values) {
                this.getDataRequirement().add(value);
            }
        }
        return this;
    }

    public DecisionSupportServiceModule withDataRequirement(Collection<DataRequirement> values) {
        if (values != null) {
            this.getDataRequirement().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportServiceModule withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DecisionSupportServiceModule withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DecisionSupportServiceModule withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportServiceModule withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DecisionSupportServiceModule withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportServiceModule withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DecisionSupportServiceModule withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportServiceModule withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DecisionSupportServiceModule withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DecisionSupportServiceModule withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DecisionSupportServiceModule withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DecisionSupportServiceModule that = (DecisionSupportServiceModule)object;
        ModuleMetadata lhsModuleMetadata = this.getModuleMetadata();
        ModuleMetadata rhsModuleMetadata = that.getModuleMetadata();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"moduleMetadata", (Object)lhsModuleMetadata), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"moduleMetadata", (Object)rhsModuleMetadata), (Object)lhsModuleMetadata, (Object)rhsModuleMetadata, this.moduleMetadata != null, that.moduleMetadata != null)) {
            return false;
        }
        List<TriggerDefinition> lhsTrigger = this.trigger != null && !this.trigger.isEmpty() ? this.getTrigger() : null;
        List<TriggerDefinition> rhsTrigger = that.trigger != null && !that.trigger.isEmpty() ? that.getTrigger() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"trigger", lhsTrigger), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"trigger", rhsTrigger), lhsTrigger, rhsTrigger, this.trigger != null && !this.trigger.isEmpty(), that.trigger != null && !that.trigger.isEmpty())) {
            return false;
        }
        List<ParameterDefinition> lhsParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        List<ParameterDefinition> rhsParameter = that.parameter != null && !that.parameter.isEmpty() ? that.getParameter() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"parameter", lhsParameter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"parameter", rhsParameter), lhsParameter, rhsParameter, this.parameter != null && !this.parameter.isEmpty(), that.parameter != null && !that.parameter.isEmpty())) {
            return false;
        }
        List<DataRequirement> lhsDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        List<DataRequirement> rhsDataRequirement = that.dataRequirement != null && !that.dataRequirement.isEmpty() ? that.getDataRequirement() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dataRequirement", lhsDataRequirement), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dataRequirement", rhsDataRequirement), lhsDataRequirement, rhsDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty(), that.dataRequirement != null && !that.dataRequirement.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"moduleMetadata", (Object)theModuleMetadata), currentHashCode, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<TriggerDefinition> theTrigger = this.trigger != null && !this.trigger.isEmpty() ? this.getTrigger() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"trigger", theTrigger), currentHashCode, theTrigger, this.trigger != null && !this.trigger.isEmpty());
        List<ParameterDefinition> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"parameter", theParameter), currentHashCode, theParameter, this.parameter != null && !this.parameter.isEmpty());
        List<DataRequirement> theDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dataRequirement", theDataRequirement), currentHashCode, theDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        strategy.appendField(locator, (Object)this, "moduleMetadata", buffer, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<TriggerDefinition> theTrigger = this.trigger != null && !this.trigger.isEmpty() ? this.getTrigger() : null;
        strategy.appendField(locator, (Object)this, "trigger", buffer, theTrigger, this.trigger != null && !this.trigger.isEmpty());
        List<ParameterDefinition> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        strategy.appendField(locator, (Object)this, "parameter", buffer, theParameter, this.parameter != null && !this.parameter.isEmpty());
        List<DataRequirement> theDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        strategy.appendField(locator, (Object)this, "dataRequirement", buffer, theDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty());
        return buffer;
    }
}

