/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AggregationMode;
import org.hl7.fhir.Code;
import org.hl7.fhir.Element;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ReferenceVersionRules;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ElementDefinition.Type", propOrder={"code", "profile", "aggregation", "versioning"})
public class ElementDefinitionType
extends Element
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Code code;
    protected List<Uri> profile;
    protected List<AggregationMode> aggregation;
    protected ReferenceVersionRules versioning;

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public List<Uri> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<Uri>();
        }
        return this.profile;
    }

    public List<AggregationMode> getAggregation() {
        if (this.aggregation == null) {
            this.aggregation = new ArrayList<AggregationMode>();
        }
        return this.aggregation;
    }

    public ReferenceVersionRules getVersioning() {
        return this.versioning;
    }

    public void setVersioning(ReferenceVersionRules value) {
        this.versioning = value;
    }

    public ElementDefinitionType withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public ElementDefinitionType withProfile(Uri ... values) {
        if (values != null) {
            for (Uri value : values) {
                this.getProfile().add(value);
            }
        }
        return this;
    }

    public ElementDefinitionType withProfile(Collection<Uri> values) {
        if (values != null) {
            this.getProfile().addAll(values);
        }
        return this;
    }

    public ElementDefinitionType withAggregation(AggregationMode ... values) {
        if (values != null) {
            for (AggregationMode value : values) {
                this.getAggregation().add(value);
            }
        }
        return this;
    }

    public ElementDefinitionType withAggregation(Collection<AggregationMode> values) {
        if (values != null) {
            this.getAggregation().addAll(values);
        }
        return this;
    }

    public ElementDefinitionType withVersioning(ReferenceVersionRules value) {
        this.setVersioning(value);
        return this;
    }

    @Override
    public ElementDefinitionType withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ElementDefinitionType withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ElementDefinitionType withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ElementDefinitionType that = (ElementDefinitionType)object;
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        List<Uri> lhsProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        List<Uri> rhsProfile = that.profile != null && !that.profile.isEmpty() ? that.getProfile() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"profile", lhsProfile), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"profile", rhsProfile), lhsProfile, rhsProfile, this.profile != null && !this.profile.isEmpty(), that.profile != null && !that.profile.isEmpty())) {
            return false;
        }
        List<AggregationMode> lhsAggregation = this.aggregation != null && !this.aggregation.isEmpty() ? this.getAggregation() : null;
        List<AggregationMode> rhsAggregation = that.aggregation != null && !that.aggregation.isEmpty() ? that.getAggregation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"aggregation", lhsAggregation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"aggregation", rhsAggregation), lhsAggregation, rhsAggregation, this.aggregation != null && !this.aggregation.isEmpty(), that.aggregation != null && !that.aggregation.isEmpty())) {
            return false;
        }
        ReferenceVersionRules lhsVersioning = this.getVersioning();
        ReferenceVersionRules rhsVersioning = that.getVersioning();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"versioning", (Object)lhsVersioning), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"versioning", (Object)rhsVersioning), (Object)lhsVersioning, (Object)rhsVersioning, this.versioning != null, that.versioning != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"code", (Object)theCode), currentHashCode, (Object)theCode, this.code != null);
        List<Uri> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"profile", theProfile), currentHashCode, theProfile, this.profile != null && !this.profile.isEmpty());
        List<AggregationMode> theAggregation = this.aggregation != null && !this.aggregation.isEmpty() ? this.getAggregation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"aggregation", theAggregation), currentHashCode, theAggregation, this.aggregation != null && !this.aggregation.isEmpty());
        ReferenceVersionRules theVersioning = this.getVersioning();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"versioning", (Object)theVersioning), currentHashCode, (Object)theVersioning, this.versioning != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode, this.code != null);
        List<Uri> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        strategy.appendField(locator, (Object)this, "profile", buffer, theProfile, this.profile != null && !this.profile.isEmpty());
        List<AggregationMode> theAggregation = this.aggregation != null && !this.aggregation.isEmpty() ? this.getAggregation() : null;
        strategy.appendField(locator, (Object)this, "aggregation", buffer, theAggregation, this.aggregation != null && !this.aggregation.isEmpty());
        ReferenceVersionRules theVersioning = this.getVersioning();
        strategy.appendField(locator, (Object)this, "versioning", buffer, (Object)theVersioning, this.versioning != null);
        return buffer;
    }
}

