/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Coding;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ExtensionContext;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.StructureDefinitionContact;
import org.hl7.fhir.StructureDefinitionDifferential;
import org.hl7.fhir.StructureDefinitionKind;
import org.hl7.fhir.StructureDefinitionMapping;
import org.hl7.fhir.StructureDefinitionSnapshot;
import org.hl7.fhir.TypeDerivationRule;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StructureDefinition", propOrder={"url", "identifier", "version", "name", "display", "status", "experimental", "publisher", "contact", "date", "description", "useContext", "requirements", "copyright", "code", "fhirVersion", "mapping", "kind", "_abstract", "contextType", "context", "baseType", "baseDefinition", "derivation", "snapshot", "differential"})
public class StructureDefinition
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri url;
    protected List<Identifier> identifier;
    protected String version;
    @XmlElement(required=true)
    protected String name;
    protected String display;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<StructureDefinitionContact> contact;
    protected DateTime date;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    protected String copyright;
    protected List<Coding> code;
    protected Id fhirVersion;
    protected List<StructureDefinitionMapping> mapping;
    @XmlElement(required=true)
    protected StructureDefinitionKind kind;
    @XmlElement(name="abstract", required=true)
    protected Boolean _abstract;
    protected ExtensionContext contextType;
    protected List<String> context;
    protected Code baseType;
    protected Uri baseDefinition;
    protected TypeDerivationRule derivation;
    protected StructureDefinitionSnapshot snapshot;
    protected StructureDefinitionDifferential differential;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String value) {
        this.display = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<StructureDefinitionContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<StructureDefinitionContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public List<Coding> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        return this.code;
    }

    public Id getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(Id value) {
        this.fhirVersion = value;
    }

    public List<StructureDefinitionMapping> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMapping>();
        }
        return this.mapping;
    }

    public StructureDefinitionKind getKind() {
        return this.kind;
    }

    public void setKind(StructureDefinitionKind value) {
        this.kind = value;
    }

    public Boolean getAbstract() {
        return this._abstract;
    }

    public void setAbstract(Boolean value) {
        this._abstract = value;
    }

    public ExtensionContext getContextType() {
        return this.contextType;
    }

    public void setContextType(ExtensionContext value) {
        this.contextType = value;
    }

    public List<String> getContext() {
        if (this.context == null) {
            this.context = new ArrayList<String>();
        }
        return this.context;
    }

    public Code getBaseType() {
        return this.baseType;
    }

    public void setBaseType(Code value) {
        this.baseType = value;
    }

    public Uri getBaseDefinition() {
        return this.baseDefinition;
    }

    public void setBaseDefinition(Uri value) {
        this.baseDefinition = value;
    }

    public TypeDerivationRule getDerivation() {
        return this.derivation;
    }

    public void setDerivation(TypeDerivationRule value) {
        this.derivation = value;
    }

    public StructureDefinitionSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(StructureDefinitionSnapshot value) {
        this.snapshot = value;
    }

    public StructureDefinitionDifferential getDifferential() {
        return this.differential;
    }

    public void setDifferential(StructureDefinitionDifferential value) {
        this.differential = value;
    }

    public StructureDefinition withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public StructureDefinition withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public StructureDefinition withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public StructureDefinition withName(String value) {
        this.setName(value);
        return this;
    }

    public StructureDefinition withDisplay(String value) {
        this.setDisplay(value);
        return this;
    }

    public StructureDefinition withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public StructureDefinition withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public StructureDefinition withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public StructureDefinition withContact(StructureDefinitionContact ... values) {
        if (values != null) {
            for (StructureDefinitionContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withContact(Collection<StructureDefinitionContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public StructureDefinition withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public StructureDefinition withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public StructureDefinition withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public StructureDefinition withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public StructureDefinition withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public StructureDefinition withCode(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getCode().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withCode(Collection<Coding> values) {
        if (values != null) {
            this.getCode().addAll(values);
        }
        return this;
    }

    public StructureDefinition withFhirVersion(Id value) {
        this.setFhirVersion(value);
        return this;
    }

    public StructureDefinition withMapping(StructureDefinitionMapping ... values) {
        if (values != null) {
            for (StructureDefinitionMapping value : values) {
                this.getMapping().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withMapping(Collection<StructureDefinitionMapping> values) {
        if (values != null) {
            this.getMapping().addAll(values);
        }
        return this;
    }

    public StructureDefinition withKind(StructureDefinitionKind value) {
        this.setKind(value);
        return this;
    }

    public StructureDefinition withAbstract(Boolean value) {
        this.setAbstract(value);
        return this;
    }

    public StructureDefinition withContextType(ExtensionContext value) {
        this.setContextType(value);
        return this;
    }

    public StructureDefinition withContext(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getContext().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withContext(Collection<String> values) {
        if (values != null) {
            this.getContext().addAll(values);
        }
        return this;
    }

    public StructureDefinition withBaseType(Code value) {
        this.setBaseType(value);
        return this;
    }

    public StructureDefinition withBaseDefinition(Uri value) {
        this.setBaseDefinition(value);
        return this;
    }

    public StructureDefinition withDerivation(TypeDerivationRule value) {
        this.setDerivation(value);
        return this;
    }

    public StructureDefinition withSnapshot(StructureDefinitionSnapshot value) {
        this.setSnapshot(value);
        return this;
    }

    public StructureDefinition withDifferential(StructureDefinitionDifferential value) {
        this.setDifferential(value);
        return this;
    }

    @Override
    public StructureDefinition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public StructureDefinition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureDefinition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public StructureDefinition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureDefinition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureDefinition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureDefinition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureDefinition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public StructureDefinition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public StructureDefinition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public StructureDefinition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        StructureDefinition that = (StructureDefinition)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName, this.name != null, that.name != null)) {
            return false;
        }
        String lhsDisplay = this.getDisplay();
        String rhsDisplay = that.getDisplay();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"display", (Object)lhsDisplay), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"display", (Object)rhsDisplay), (Object)lhsDisplay, (Object)rhsDisplay, this.display != null, that.display != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<StructureDefinitionContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<StructureDefinitionContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyright", (Object)lhsCopyright), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyright", (Object)rhsCopyright), (Object)lhsCopyright, (Object)rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        List<Coding> lhsCode = this.code != null && !this.code.isEmpty() ? this.getCode() : null;
        List<Coding> rhsCode = that.code != null && !that.code.isEmpty() ? that.getCode() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", rhsCode), lhsCode, rhsCode, this.code != null && !this.code.isEmpty(), that.code != null && !that.code.isEmpty())) {
            return false;
        }
        Id lhsFhirVersion = this.getFhirVersion();
        Id rhsFhirVersion = that.getFhirVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fhirVersion", (Object)lhsFhirVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fhirVersion", (Object)rhsFhirVersion), (Object)lhsFhirVersion, (Object)rhsFhirVersion, this.fhirVersion != null, that.fhirVersion != null)) {
            return false;
        }
        List<StructureDefinitionMapping> lhsMapping = this.mapping != null && !this.mapping.isEmpty() ? this.getMapping() : null;
        List<StructureDefinitionMapping> rhsMapping = that.mapping != null && !that.mapping.isEmpty() ? that.getMapping() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"mapping", lhsMapping), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"mapping", rhsMapping), lhsMapping, rhsMapping, this.mapping != null && !this.mapping.isEmpty(), that.mapping != null && !that.mapping.isEmpty())) {
            return false;
        }
        StructureDefinitionKind lhsKind = this.getKind();
        StructureDefinitionKind rhsKind = that.getKind();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"kind", (Object)lhsKind), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"kind", (Object)rhsKind), (Object)lhsKind, (Object)rhsKind, this.kind != null, that.kind != null)) {
            return false;
        }
        Boolean lhsAbstract = this.getAbstract();
        Boolean rhsAbstract = that.getAbstract();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"_abstract", (Object)lhsAbstract), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"_abstract", (Object)rhsAbstract), (Object)lhsAbstract, (Object)rhsAbstract, this._abstract != null, that._abstract != null)) {
            return false;
        }
        ExtensionContext lhsContextType = this.getContextType();
        ExtensionContext rhsContextType = that.getContextType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contextType", (Object)lhsContextType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contextType", (Object)rhsContextType), (Object)lhsContextType, (Object)rhsContextType, this.contextType != null, that.contextType != null)) {
            return false;
        }
        List<String> lhsContext = this.context != null && !this.context.isEmpty() ? this.getContext() : null;
        List<String> rhsContext = that.context != null && !that.context.isEmpty() ? that.getContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"context", lhsContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"context", rhsContext), lhsContext, rhsContext, this.context != null && !this.context.isEmpty(), that.context != null && !that.context.isEmpty())) {
            return false;
        }
        Code lhsBaseType = this.getBaseType();
        Code rhsBaseType = that.getBaseType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"baseType", (Object)lhsBaseType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"baseType", (Object)rhsBaseType), (Object)lhsBaseType, (Object)rhsBaseType, this.baseType != null, that.baseType != null)) {
            return false;
        }
        Uri lhsBaseDefinition = this.getBaseDefinition();
        Uri rhsBaseDefinition = that.getBaseDefinition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"baseDefinition", (Object)lhsBaseDefinition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"baseDefinition", (Object)rhsBaseDefinition), (Object)lhsBaseDefinition, (Object)rhsBaseDefinition, this.baseDefinition != null, that.baseDefinition != null)) {
            return false;
        }
        TypeDerivationRule lhsDerivation = this.getDerivation();
        TypeDerivationRule rhsDerivation = that.getDerivation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"derivation", (Object)lhsDerivation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"derivation", (Object)rhsDerivation), (Object)lhsDerivation, (Object)rhsDerivation, this.derivation != null, that.derivation != null)) {
            return false;
        }
        StructureDefinitionSnapshot lhsSnapshot = this.getSnapshot();
        StructureDefinitionSnapshot rhsSnapshot = that.getSnapshot();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"snapshot", (Object)lhsSnapshot), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"snapshot", (Object)rhsSnapshot), (Object)lhsSnapshot, (Object)rhsSnapshot, this.snapshot != null, that.snapshot != null)) {
            return false;
        }
        StructureDefinitionDifferential lhsDifferential = this.getDifferential();
        StructureDefinitionDifferential rhsDifferential = that.getDifferential();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"differential", (Object)lhsDifferential), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"differential", (Object)rhsDifferential), (Object)lhsDifferential, (Object)rhsDifferential, this.differential != null, that.differential != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl, this.url != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName, this.name != null);
        String theDisplay = this.getDisplay();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"display", (Object)theDisplay), currentHashCode, (Object)theDisplay, this.display != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher, this.publisher != null);
        List<StructureDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyright", (Object)theCopyright), currentHashCode, (Object)theCopyright, this.copyright != null);
        List<Coding> theCode = this.code != null && !this.code.isEmpty() ? this.getCode() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", theCode), currentHashCode, theCode, this.code != null && !this.code.isEmpty());
        Id theFhirVersion = this.getFhirVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fhirVersion", (Object)theFhirVersion), currentHashCode, (Object)theFhirVersion, this.fhirVersion != null);
        List<StructureDefinitionMapping> theMapping = this.mapping != null && !this.mapping.isEmpty() ? this.getMapping() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"mapping", theMapping), currentHashCode, theMapping, this.mapping != null && !this.mapping.isEmpty());
        StructureDefinitionKind theKind = this.getKind();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"kind", (Object)theKind), currentHashCode, (Object)theKind, this.kind != null);
        Boolean theAbstract = this.getAbstract();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"_abstract", (Object)theAbstract), currentHashCode, (Object)theAbstract, this._abstract != null);
        ExtensionContext theContextType = this.getContextType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contextType", (Object)theContextType), currentHashCode, (Object)theContextType, this.contextType != null);
        List<String> theContext = this.context != null && !this.context.isEmpty() ? this.getContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"context", theContext), currentHashCode, theContext, this.context != null && !this.context.isEmpty());
        Code theBaseType = this.getBaseType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"baseType", (Object)theBaseType), currentHashCode, (Object)theBaseType, this.baseType != null);
        Uri theBaseDefinition = this.getBaseDefinition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"baseDefinition", (Object)theBaseDefinition), currentHashCode, (Object)theBaseDefinition, this.baseDefinition != null);
        TypeDerivationRule theDerivation = this.getDerivation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"derivation", (Object)theDerivation), currentHashCode, (Object)theDerivation, this.derivation != null);
        StructureDefinitionSnapshot theSnapshot = this.getSnapshot();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"snapshot", (Object)theSnapshot), currentHashCode, (Object)theSnapshot, this.snapshot != null);
        StructureDefinitionDifferential theDifferential = this.getDifferential();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"differential", (Object)theDifferential), currentHashCode, (Object)theDifferential, this.differential != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl, this.url != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName, this.name != null);
        String theDisplay = this.getDisplay();
        strategy.appendField(locator, (Object)this, "display", buffer, (Object)theDisplay, this.display != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher, this.publisher != null);
        List<StructureDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, (Object)theCopyright, this.copyright != null);
        List<Coding> theCode = this.code != null && !this.code.isEmpty() ? this.getCode() : null;
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null && !this.code.isEmpty());
        Id theFhirVersion = this.getFhirVersion();
        strategy.appendField(locator, (Object)this, "fhirVersion", buffer, (Object)theFhirVersion, this.fhirVersion != null);
        List<StructureDefinitionMapping> theMapping = this.mapping != null && !this.mapping.isEmpty() ? this.getMapping() : null;
        strategy.appendField(locator, (Object)this, "mapping", buffer, theMapping, this.mapping != null && !this.mapping.isEmpty());
        StructureDefinitionKind theKind = this.getKind();
        strategy.appendField(locator, (Object)this, "kind", buffer, (Object)theKind, this.kind != null);
        Boolean theAbstract = this.getAbstract();
        strategy.appendField(locator, (Object)this, "_abstract", buffer, (Object)theAbstract, this._abstract != null);
        ExtensionContext theContextType = this.getContextType();
        strategy.appendField(locator, (Object)this, "contextType", buffer, (Object)theContextType, this.contextType != null);
        List<String> theContext = this.context != null && !this.context.isEmpty() ? this.getContext() : null;
        strategy.appendField(locator, (Object)this, "context", buffer, theContext, this.context != null && !this.context.isEmpty());
        Code theBaseType = this.getBaseType();
        strategy.appendField(locator, (Object)this, "baseType", buffer, (Object)theBaseType, this.baseType != null);
        Uri theBaseDefinition = this.getBaseDefinition();
        strategy.appendField(locator, (Object)this, "baseDefinition", buffer, (Object)theBaseDefinition, this.baseDefinition != null);
        TypeDerivationRule theDerivation = this.getDerivation();
        strategy.appendField(locator, (Object)this, "derivation", buffer, (Object)theDerivation, this.derivation != null);
        StructureDefinitionSnapshot theSnapshot = this.getSnapshot();
        strategy.appendField(locator, (Object)this, "snapshot", buffer, (Object)theSnapshot, this.snapshot != null);
        StructureDefinitionDifferential theDifferential = this.getDifferential();
        strategy.appendField(locator, (Object)this, "differential", buffer, (Object)theDifferential, this.differential != null);
        return buffer;
    }
}

