/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import info.debatty.java.lsh.LSH;
import info.debatty.java.lsh.SuperBit;
import info.debatty.java.utils.SparseDoubleVector;
import info.debatty.java.utils.SparseIntegerVector;
import java.io.Serializable;

public class LSHSuperBit
extends LSH
implements Serializable {
    private SuperBit sb;

    public LSHSuperBit(int s, int b, int n) throws Exception {
        super(s, b, n);
        int superbit;
        int K = s * b / 2;
        for (superbit = n; superbit >= 1 && K % superbit != 0; --superbit) {
        }
        if (superbit == 0) {
            throw new Exception("Superbit is 0 with parameters: s=" + s + " b=" + b + " n=" + n);
        }
        this.sb = new SuperBit(n, superbit, K / superbit);
    }

    public LSHSuperBit() {
    }

    public int[] hash(double[] vector) {
        return this.hashSignature(this.sb.signature(vector));
    }

    public int[] hash(SparseIntegerVector vector) {
        return this.hashSignature(this.sb.signature(vector));
    }

    public int[] hash(SparseDoubleVector vector) {
        return this.hashSignature(this.sb.signature(vector));
    }

    public int[] hash(int[] vector) {
        double[] d = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            d[i] = vector[i];
        }
        return this.hash(d);
    }
}

