/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojo.test;

import com.thoughtworks.xstream.XStream;
import info.flexmojos.compile.test.report.TestCaseReport;
import info.rvin.flexmojo.test.FlexUnitLauncher;
import info.rvin.flexmojo.test.util.XStreamFactory;
import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.AbstractIrvinMojo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class FlexUnitMojo
extends AbstractIrvinMojo {
    private static final String END_OF_TEST_RUN = "<endOfTestRun/>";
    private static final String END_OF_TEST_SUITE = "</testsuite>";
    private static final String END_OF_TEST_ACK = "<endOfTestRunAck/>";
    private static final char NULL_BYTE = '\u0000';
    private static final String POLICY_FILE_REQUEST = "<policy-file-request/>";
    static final String DOMAIN_POLICY = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"{0}\" /></cross-domain-policy>";
    private boolean failures = false;
    private boolean complete;
    private int testPort;
    private int socketTimeout = 60000;
    private List<String> flexUnitCommand;
    protected File swf;
    private MojoExecutionException executionError;
    private boolean skip;
    private boolean skipTest;
    private File reportPath;
    private boolean testFailureIgnore;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Flex-mojos " + MavenUtils.getFlexMojosVersion() + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file"));
        this.setUp();
        if (this.skip || this.skipTest) {
            this.getLog().info((CharSequence)"Skipping test phase.");
        } else if (this.swf == null || !this.swf.exists()) {
            this.getLog().warn((CharSequence)("Skipping test run. Runner not found: " + this.swf));
        } else {
            this.run();
            this.tearDown();
        }
    }

    protected void setUp() throws MojoExecutionException, MojoFailureException {
        this.swf = new File(this.build.getTestOutputDirectory(), "TestRunner.swf");
        this.reportPath = new File(this.build.getDirectory(), "surefire-reports");
        this.reportPath.mkdirs();
    }

    private void receiveFlexUnitResults() throws MojoExecutionException {
        Thread thread = new Thread(){
            private ServerSocket serverSocket = null;
            private Socket clientSocket = null;
            private InputStream in = null;
            private OutputStream out = null;

            public void run() {
                try {
                    try {
                        this.openServerSocket();
                        this.openClientSocket();
                        StringBuffer buffer = new StringBuffer();
                        int bite = -1;
                        while ((bite = this.in.read()) != -1) {
                            char chr = (char)bite;
                            if (chr == '\u0000') {
                                String data = buffer.toString();
                                FlexUnitMojo.this.getLog().debug((CharSequence)("Recivied data: " + data));
                                buffer = new StringBuffer();
                                if (data.equals(FlexUnitMojo.POLICY_FILE_REQUEST)) {
                                    FlexUnitMojo.this.getLog().debug((CharSequence)"Send policy file");
                                    this.sendPolicyFile();
                                    this.closeClientSocket();
                                    this.openClientSocket();
                                    continue;
                                }
                                if (data.endsWith(FlexUnitMojo.END_OF_TEST_SUITE)) {
                                    FlexUnitMojo.this.getLog().debug((CharSequence)"End test suite");
                                    this.saveTestReport(data);
                                    continue;
                                }
                                if (!data.equals(FlexUnitMojo.END_OF_TEST_RUN)) continue;
                                FlexUnitMojo.this.getLog().debug((CharSequence)"End test run");
                                this.sendAcknowledgement();
                                continue;
                            }
                            buffer.append(chr);
                        }
                        FlexUnitMojo.this.getLog().debug((CharSequence)("Socket buffer " + buffer));
                    }
                    catch (MojoExecutionException be) {
                        FlexUnitMojo.this.executionError = be;
                        try {
                            this.sendAcknowledgement();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (SocketTimeoutException e) {
                        FlexUnitMojo.this.executionError = new MojoExecutionException("timeout waiting for flexunit report", (Exception)e);
                    }
                    catch (IOException e) {
                        FlexUnitMojo.this.executionError = new MojoExecutionException("error receiving report from flexunit", (Exception)e);
                    }
                }
                finally {
                    FlexUnitMojo.this.complete = true;
                    this.closeClientSocket();
                    this.closeServerSocket();
                }
            }

            private void sendPolicyFile() throws IOException {
                this.out.write(MessageFormat.format(FlexUnitMojo.DOMAIN_POLICY, Integer.toString(FlexUnitMojo.this.testPort)).getBytes());
                this.out.write(0);
                FlexUnitMojo.this.getLog().debug((CharSequence)"sent policy file");
            }

            private void saveTestReport(String report) throws MojoExecutionException {
                FlexUnitMojo.this.writeTestReport(report);
                FlexUnitMojo.this.getLog().debug((CharSequence)"end of test");
            }

            private void sendAcknowledgement() throws IOException {
                this.out.write(FlexUnitMojo.END_OF_TEST_ACK.getBytes());
                this.out.write(0);
                FlexUnitMojo.this.getLog().debug((CharSequence)"end of test run");
            }

            private void openServerSocket() throws IOException {
                this.serverSocket = new ServerSocket(FlexUnitMojo.this.testPort);
                this.serverSocket.setSoTimeout(FlexUnitMojo.this.socketTimeout);
                FlexUnitMojo.this.getLog().debug((CharSequence)"opened server socket");
            }

            private void closeServerSocket() {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }

            private void openClientSocket() throws IOException {
                this.clientSocket = this.serverSocket.accept();
                FlexUnitMojo.this.getLog().debug((CharSequence)"accepting data from client");
                this.in = this.clientSocket.getInputStream();
                this.out = this.clientSocket.getOutputStream();
            }

            private void closeClientSocket() {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.clientSocket != null) {
                    try {
                        this.clientSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        thread.start();
    }

    private void writeTestReport(String reportString) throws MojoExecutionException {
        try {
            XStream xs = XStreamFactory.getXStreamInstance();
            TestCaseReport report = (TestCaseReport)xs.fromXML(reportString);
            String name = report.getName();
            int numFailures = report.getFailures();
            int numErrors = report.getErrors();
            int totalProblems = numFailures + numErrors;
            this.getLog().debug((CharSequence)("Running " + name));
            this.getLog().debug((CharSequence)reportString);
            File file = new File(this.reportPath, "TEST-" + name.replace("::", ".") + ".xml");
            FileWriter writer = new FileWriter(file);
            xs.toXML((Object)report, (Writer)writer);
            writer.flush();
            writer.close();
            if (totalProblems > 0) {
                this.failures = true;
                this.getLog().info((CharSequence)("Unit test " + name + " failed."));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("error writing report to disk", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void run() throws MojoExecutionException, MojoFailureException {
        this.receiveFlexUnitResults();
        this.getLog().info((CharSequence)("flexunit setup args: " + this.flexUnitCommand));
        browser = new FlexUnitLauncher(this.flexUnitCommand, this.getLog());
        try {
            browser.runTests(this.swf);
            if (true) ** GOTO lbl15
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error launching the test runner.", e);
        }
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
lbl15:
            // 2 sources

        } while (!this.complete);
    }

    protected void tearDown() throws MojoExecutionException, MojoFailureException {
        if (!this.testFailureIgnore) {
            if (this.executionError != null) {
                throw this.executionError;
            }
            if (this.failures) {
                throw new MojoExecutionException("Some tests fail");
            }
        } else {
            if (this.executionError != null) {
                this.getLog().error((CharSequence)this.executionError.getMessage(), (Throwable)this.executionError);
            }
            if (this.failures) {
                this.getLog().error((CharSequence)"Some tests fail");
            }
        }
    }
}

