/*
 * Decompiled with CFR 0.152.
 */
package info.jerrinot.subzero;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import info.jerrinot.subzero.AbstractGlobalUserSerializer;
import info.jerrinot.subzero.AbstractSerializer;
import info.jerrinot.subzero.Serializer;

public final class SubZero {
    private SubZero() {
    }

    public static Config useAsGlobalSerializer(Config config) {
        return SubZero.useAsGlobalSerializerInternal(config, Serializer.class);
    }

    public static Config useAsGlobalSerializer(Config config, Class<? extends AbstractGlobalUserSerializer> serializerClazz) {
        SerializationConfig serializationConfig = config.getSerializationConfig();
        SubZero.injectSubZero(serializationConfig, serializerClazz);
        return config;
    }

    public static <T> T useAsGlobalSerializer(T config) {
        return SubZero.useAsGlobalSerializerInternal(config, Serializer.class);
    }

    public static <T> T useAsGlobalSerializer(T config, Class<? extends AbstractGlobalUserSerializer> serializerClazz) {
        return SubZero.useAsGlobalSerializerInternal(config, serializerClazz);
    }

    private static <T> T useAsGlobalSerializerInternal(T config, Class<? extends AbstractSerializer> serializerClazz) {
        SerializationConfig serializationConfig = SubZero.extractSerializationConfig(config);
        SubZero.injectSubZero(serializationConfig, serializerClazz);
        return config;
    }

    private static SerializationConfig extractSerializationConfig(Object config) {
        SerializationConfig serializationConfig;
        String className = config.getClass().getName();
        if (className.equals("com.hazelcast.client.config.ClientConfig")) {
            ClientConfig clientConfig = (ClientConfig)config;
            serializationConfig = clientConfig.getSerializationConfig();
        } else if (className.equals("com.hazelcast.config.Config")) {
            Config memberConfig = (Config)config;
            serializationConfig = memberConfig.getSerializationConfig();
        } else {
            throw new IllegalArgumentException("Unknown configuration object " + config);
        }
        return serializationConfig;
    }

    private static void injectSubZero(SerializationConfig serializationConfig, Class<? extends AbstractSerializer> serializerClazz) {
        GlobalSerializerConfig globalSerializerConfig = serializationConfig.getGlobalSerializerConfig();
        if (globalSerializerConfig == null) {
            globalSerializerConfig = new GlobalSerializerConfig();
            serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
        }
        globalSerializerConfig.setClassName(serializerClazz.getName()).setOverrideJavaSerialization(true);
    }

    public static Config useForClasses(Config config, Class<?> ... classes) {
        return SubZero.useForClassesInternal(config, classes);
    }

    public static <T> T useForClasses(T config, Class<?> ... classes) {
        return SubZero.useForClassesInternal(config, classes);
    }

    private static <T> T useForClassesInternal(T config, Class<?> ... classes) {
        SerializationConfig serializationConfig = SubZero.extractSerializationConfig(config);
        for (Class<?> clazz : classes) {
            SerializerConfig serializerConfig = new SerializerConfig();
            Serializer serializer = new Serializer(clazz);
            serializerConfig.setImplementation(serializer);
            serializerConfig.setTypeClass(clazz);
            serializationConfig.addSerializerConfig(serializerConfig);
        }
        return config;
    }
}

