/*
 * Decompiled with CFR 0.152.
 */
package info.jerrinot.subzero.internal;

import com.hazelcast.core.HazelcastInstance;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IdGeneratorUtils {
    private static final int BASE_ID = Integer.getInteger("subzero.base.type.id", 6000);
    private static ConcurrentHashMap<HazelcastInstance, IdSequence> counterMap = new ConcurrentHashMap();

    public static int newIdForType(HazelcastInstance hz, Class<?> type) {
        IdSequence idSequence = IdGeneratorUtils.getOrCreateSequence(hz);
        return idSequence.newIdFor(type);
    }

    public static int newId(HazelcastInstance hz) {
        IdSequence idSequence = IdGeneratorUtils.getOrCreateSequence(hz);
        return idSequence.newId();
    }

    public static void instanceDestroyed(HazelcastInstance hz) {
        counterMap.remove(hz);
    }

    private static IdSequence getOrCreateSequence(HazelcastInstance hazelcastInstance) {
        IdSequence currentSequence = counterMap.get(hazelcastInstance);
        if (currentSequence != null) {
            return currentSequence;
        }
        IdSequence newSequence = new IdSequence();
        currentSequence = counterMap.putIfAbsent(hazelcastInstance, newSequence);
        return currentSequence == null ? newSequence : currentSequence;
    }

    static /* synthetic */ int access$300() {
        return BASE_ID;
    }

    private static class IdSequence {
        private Set<Class<?>> knownTypes = Collections.newSetFromMap(new ConcurrentHashMap());
        private AtomicInteger counter = new AtomicInteger(IdGeneratorUtils.access$300());

        private IdSequence() {
        }

        private int newIdFor(Class<?> clazz) {
            boolean added = this.knownTypes.add(clazz);
            if (!added) {
                throw new AssertionError((Object)("A serializer for " + clazz + " has been configured twice"));
            }
            return this.counter.getAndIncrement();
        }

        private int newId() {
            return this.counter.getAndIncrement();
        }
    }
}

