/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns;

import io.activej.dns.protocol.DnsQuery;
import io.activej.dns.protocol.DnsResourceRecord;
import io.activej.dns.protocol.DnsResponse;
import io.activej.dns.protocol.DnsTransaction;
import io.activej.http.HttpUtils;
import io.activej.promise.Promise;
import java.net.InetAddress;
import org.jetbrains.annotations.Nullable;

public interface AsyncDnsClient {
    default public Promise<DnsResponse> resolve4(String domainName) {
        return this.resolve(DnsQuery.ipv4(domainName));
    }

    default public Promise<DnsResponse> resolve6(String domainName) {
        return this.resolve(DnsQuery.ipv6(domainName));
    }

    public Promise<DnsResponse> resolve(DnsQuery var1);

    public void close();

    @Nullable
    public static DnsResponse resolveFromQuery(DnsQuery query) {
        if ("localhost".equals(query.getDomainName())) {
            InetAddress[] ips = new InetAddress[]{InetAddress.getLoopbackAddress()};
            return DnsResponse.of(DnsTransaction.of((short)0, query), DnsResourceRecord.of(ips, 0));
        }
        if (HttpUtils.isInetAddress(query.getDomainName())) {
            InetAddress[] ips = new InetAddress[]{HttpUtils.inetAddress(query.getDomainName())};
            return DnsResponse.of(DnsTransaction.of((short)0, query), DnsResourceRecord.of(ips, 0));
        }
        return null;
    }
}

