/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns;

import io.activej.common.Checks;
import io.activej.dns.AsyncDnsClient;
import io.activej.dns.DnsCache;
import io.activej.dns.protocol.DnsQuery;
import io.activej.dns.protocol.DnsQueryException;
import io.activej.dns.protocol.DnsResponse;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBean;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.promise.Promise;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachedAsyncDnsClient
implements AsyncDnsClient,
EventloopJmxBean {
    private final Logger logger = LoggerFactory.getLogger(CachedAsyncDnsClient.class);
    private static final boolean CHECK = Checks.isEnabled(CachedAsyncDnsClient.class);
    private final Eventloop eventloop;
    private final AsyncDnsClient client;
    private DnsCache cache;
    private final Map<DnsQuery, Promise<DnsResponse>> pending = new HashMap<DnsQuery, Promise<DnsResponse>>();
    private final Set<DnsQuery> refreshingNow = Collections.newSetFromMap(new ConcurrentHashMap());

    private CachedAsyncDnsClient(Eventloop eventloop, AsyncDnsClient client, DnsCache cache) {
        this.eventloop = eventloop;
        this.client = client;
        this.cache = cache;
    }

    public static CachedAsyncDnsClient create(Eventloop eventloop, AsyncDnsClient client, DnsCache cache) {
        return new CachedAsyncDnsClient(eventloop, client, cache);
    }

    public static CachedAsyncDnsClient create(Eventloop eventloop, AsyncDnsClient client) {
        return new CachedAsyncDnsClient(eventloop, client, DnsCache.create(eventloop));
    }

    public CachedAsyncDnsClient withCache(DnsCache cache) {
        this.cache = cache;
        return this;
    }

    public CachedAsyncDnsClient withExpiration(Duration errorCacheExpiration, Duration hardExpirationDelta) {
        return this.withExpiration(errorCacheExpiration, hardExpirationDelta, DnsCache.DEFAULT_TIMED_OUT_EXPIRATION);
    }

    public CachedAsyncDnsClient withExpiration(Duration errorCacheExpiration, Duration hardExpirationDelta, Duration timedOutExceptionTtl) {
        this.cache.withErrorCacheExpiration(errorCacheExpiration).withHardExpirationDelta(hardExpirationDelta).withTimedOutExpiration(timedOutExceptionTtl);
        return this;
    }

    public AsyncDnsClient adaptToAnotherEventloop(final Eventloop anotherEventloop) {
        if (anotherEventloop == this.eventloop) {
            return this;
        }
        return new AsyncDnsClient(){

            @Override
            public Promise<DnsResponse> resolve(DnsQuery query) {
                DnsResponse fromQuery;
                if (CHECK) {
                    Checks.checkState((boolean)anotherEventloop.inEventloopThread());
                }
                if ((fromQuery = AsyncDnsClient.resolveFromQuery(query)) != null) {
                    CachedAsyncDnsClient.this.logger.trace("{} already contained an IP address within itself", (Object)query);
                    return Promise.of((Object)fromQuery);
                }
                DnsCache.DnsQueryCacheResult cacheResult = CachedAsyncDnsClient.this.cache.tryToResolve(query);
                if (cacheResult != null) {
                    if (cacheResult.doesNeedRefreshing() && !CachedAsyncDnsClient.this.refreshingNow.add(query)) {
                        CachedAsyncDnsClient.this.eventloop.execute(() -> CachedAsyncDnsClient.this.refresh(query));
                    }
                    return cacheResult.getResponseAsPromise();
                }
                anotherEventloop.startExternalTask();
                return Promise.ofCallback(cb -> CachedAsyncDnsClient.this.eventloop.execute(() -> CachedAsyncDnsClient.this.resolve(query).whenComplete((result, e) -> {
                    anotherEventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.accept(result, e)));
                    anotherEventloop.completeExternalTask();
                })));
            }

            @Override
            public void close() {
                if (CHECK) {
                    Checks.checkState((boolean)anotherEventloop.inEventloopThread());
                }
                CachedAsyncDnsClient.this.eventloop.execute(CachedAsyncDnsClient.this::close);
            }
        };
    }

    private void addToCache(DnsQuery query, DnsResponse response, @Nullable Throwable e) {
        if (e == null) {
            this.cache.add(query, response);
        } else if (e instanceof DnsQueryException) {
            this.cache.add(query, ((DnsQueryException)e).getResult());
        }
    }

    private void refresh(DnsQuery query) {
        if (!this.refreshingNow.add(query)) {
            this.logger.trace("{} needs refreshing, but it does so right now", (Object)query);
            return;
        }
        this.logger.trace("Refreshing {}", (Object)query);
        this.client.resolve(query).whenComplete((response, e) -> {
            this.addToCache(query, (DnsResponse)response, e);
            this.refreshingNow.remove(query);
        });
    }

    @Override
    public Promise<DnsResponse> resolve(DnsQuery query) {
        DnsResponse fromQuery;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Concurrent resolves are not allowed, to reuse the cache use adaptToOtherEventloop");
        }
        if ((fromQuery = AsyncDnsClient.resolveFromQuery(query)) != null) {
            this.logger.trace("{} already contained an IP address within itself", (Object)query);
            return Promise.of((Object)fromQuery);
        }
        this.logger.trace("Resolving {}", (Object)query);
        DnsCache.DnsQueryCacheResult cacheResult = this.cache.tryToResolve(query);
        if (cacheResult != null) {
            if (cacheResult.doesNeedRefreshing()) {
                this.refresh(query);
            }
            return cacheResult.getResponseAsPromise();
        }
        this.cache.performCleanup();
        Promise<DnsResponse> promise = this.pending.get(query);
        if (promise != null) {
            return promise;
        }
        Promise resolve = this.client.resolve(query).whenComplete((response, e) -> this.addToCache(query, (DnsResponse)response, e));
        if (resolve.isComplete()) {
            return resolve;
        }
        this.pending.put(query, (Promise<DnsResponse>)resolve);
        return resolve.whenComplete((response, e) -> this.pending.remove(query));
    }

    @Override
    public void close() {
        this.client.close();
    }

    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    @JmxAttribute(name="")
    public DnsCache getCache() {
        return this.cache;
    }

    @JmxOperation
    public List<String> getResolvedDomains() {
        return this.cache.getResolvedDomains();
    }

    @JmxOperation
    public List<String> getFailedDomains() {
        return this.cache.getFailedDomains();
    }

    @JmxOperation
    public List<String> getDomainRecord(String domain) {
        return this.cache.getDomainRecord(domain);
    }

    @JmxOperation
    public List<String> getDomainRecords() {
        return this.cache.getDomainRecords();
    }

    @JmxOperation
    public void clear() {
        this.cache.clear();
    }
}

