/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns.protocol;

import io.activej.dns.protocol.DnsProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DnsQuery {
    private final String domainName;
    private final DnsProtocol.RecordType recordType;
    @Nullable
    private Object userData;

    private DnsQuery(@NotNull String domainName, @NotNull DnsProtocol.RecordType recordType) {
        this.domainName = domainName;
        this.recordType = recordType;
    }

    public static DnsQuery of(String domainName, DnsProtocol.RecordType recordType) {
        return new DnsQuery(domainName, recordType);
    }

    public static DnsQuery ipv4(String domainName) {
        return new DnsQuery(domainName, DnsProtocol.RecordType.A);
    }

    public static DnsQuery ipv6(String domainName) {
        return new DnsQuery(domainName, DnsProtocol.RecordType.AAAA);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DnsProtocol.RecordType getRecordType() {
        return this.recordType;
    }

    @Nullable
    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(@Nullable Object userData) {
        this.userData = userData;
    }

    public String toString() {
        return "DnsQuery{domainName='" + this.domainName + "', recordType=" + (Object)((Object)this.recordType) + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsQuery dnsQuery = (DnsQuery)o;
        return this.domainName.equals(dnsQuery.domainName) && this.recordType == dnsQuery.recordType;
    }

    public int hashCode() {
        return 31 * this.domainName.hashCode() + this.recordType.hashCode();
    }
}

