/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.exception.UncheckedException;
import io.activej.http.AsyncServletDecorator;
import io.activej.http.BlockingServlet;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.promise.Promisable;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncServlet {
    public static final Promise<HttpResponse> NEXT = Promise.of(null);

    @NotNull
    public Promisable<HttpResponse> serve(@NotNull HttpRequest var1) throws UncheckedException;

    @NotNull
    default public Promise<HttpResponse> serveAsync(@NotNull HttpRequest request) throws UncheckedException {
        return this.serve(request).promise();
    }

    default public AsyncServlet then(AsyncServletDecorator decorator) {
        return decorator.serve(this);
    }

    @NotNull
    public static AsyncServlet ofBlocking(@NotNull Executor executor, @NotNull BlockingServlet blockingServlet) {
        return request -> request.loadBody().then(() -> Promise.ofBlockingCallable((Executor)executor, () -> blockingServlet.serve(request)));
    }

    public static AsyncServlet firstSuccessful(AsyncServlet ... servlets) {
        return httpRequest -> Promises.first((BiPredicate)Promises.isResult(Objects::nonNull), Stream.of(servlets).map(servlet -> () -> servlet.serveAsync(httpRequest)));
    }
}

