/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.MemSize;
import io.activej.common.exception.UncheckedException;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpError;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.LoggableServlet;
import io.activej.promise.Promise;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AsyncServletDecorator {
    @NotNull
    public AsyncServlet serve(@NotNull AsyncServlet var1);

    @NotNull
    default public AsyncServlet serveFirstSuccessful(AsyncServlet ... servlets) {
        return this.serve(AsyncServlet.firstSuccessful(servlets));
    }

    public static AsyncServletDecorator create() {
        return servlet -> servlet;
    }

    default public AsyncServletDecorator then(AsyncServletDecorator next) {
        return servlet -> this.serve(next.serve(servlet));
    }

    @NotNull
    public static AsyncServletDecorator combineDecorators(AsyncServletDecorator ... decorators) {
        return AsyncServletDecorator.combineDecorators(Arrays.asList(decorators));
    }

    @NotNull
    public static AsyncServletDecorator combineDecorators(List<AsyncServletDecorator> decorators) {
        return decorators.stream().reduce(AsyncServletDecorator.create(), AsyncServletDecorator::then);
    }

    public static AsyncServletDecorator onRequest(Consumer<HttpRequest> consumer) {
        return servlet -> request -> {
            consumer.accept(request);
            return servlet.serve(request);
        };
    }

    public static AsyncServletDecorator onResponse(Consumer<HttpResponse> consumer) {
        return servlet -> request -> servlet.serveAsync(request).whenResult(consumer);
    }

    public static AsyncServletDecorator onResponse(BiConsumer<HttpRequest, HttpResponse> consumer) {
        return servlet -> request -> servlet.serveAsync(request).whenResult(response -> consumer.accept(request, (HttpResponse)response));
    }

    public static AsyncServletDecorator mapResponse(Function<HttpResponse, HttpResponse> fn) {
        return servlet -> request -> servlet.serveAsync(request).map(response -> {
            HttpResponse newResponse = (HttpResponse)fn.apply((HttpResponse)response);
            if (response != newResponse) {
                response.recycleBody();
            }
            return newResponse;
        });
    }

    public static AsyncServletDecorator mapResponse(BiFunction<HttpRequest, HttpResponse, HttpResponse> fn) {
        return servlet -> request -> servlet.serveAsync(request).map(response -> {
            HttpResponse newResponse = (HttpResponse)fn.apply(request, (HttpResponse)response);
            if (response != newResponse) {
                response.recycleBody();
            }
            return newResponse;
        });
    }

    public static AsyncServletDecorator onException(BiConsumer<HttpRequest, Throwable> consumer) {
        return servlet -> request -> servlet.serveAsync(request).whenException(e -> consumer.accept(request, (Throwable)e));
    }

    public static AsyncServletDecorator mapException(Function<Throwable, HttpResponse> fn) {
        return servlet -> request -> servlet.serveAsync(request).mapEx((response, e) -> {
            if (e == null) {
                return response;
            }
            return (HttpResponse)fn.apply((Throwable)e);
        });
    }

    public static AsyncServletDecorator mapException(BiFunction<HttpRequest, Throwable, HttpResponse> fn) {
        return servlet -> request -> servlet.serveAsync(request).mapEx((response, e) -> {
            if (e == null) {
                return response;
            }
            return (HttpResponse)fn.apply(request, (Throwable)e);
        });
    }

    public static AsyncServletDecorator mapException(Predicate<Throwable> predicate, AsyncServlet fallbackServlet) {
        return servlet -> request -> servlet.serveAsync(request).thenEx((response, e) -> predicate.test((Throwable)e) ? fallbackServlet.serveAsync(request) : Promise.of((Object)response, (Throwable)e));
    }

    public static AsyncServletDecorator mapHttpException(AsyncServlet fallbackServlet) {
        return AsyncServletDecorator.mapException(throwable -> throwable instanceof HttpError, fallbackServlet);
    }

    public static AsyncServletDecorator mapHttpException404(AsyncServlet fallbackServlet) {
        return AsyncServletDecorator.mapException(throwable -> throwable instanceof HttpError && ((HttpError)throwable).getCode() == 404, fallbackServlet);
    }

    public static AsyncServletDecorator mapHttpException500(AsyncServlet fallbackServlet) {
        return AsyncServletDecorator.mapException(throwable -> throwable instanceof HttpError && ((HttpError)throwable).getCode() == 500, fallbackServlet);
    }

    public static AsyncServletDecorator mapHttpClientException(AsyncServlet fallbackServlet) {
        return AsyncServletDecorator.mapException(throwable -> {
            if (throwable instanceof HttpError) {
                int code = ((HttpError)throwable).getCode();
                return code >= 400 && code < 500;
            }
            return false;
        }, fallbackServlet);
    }

    public static AsyncServletDecorator mapHttpServerException(AsyncServlet fallbackServlet) {
        return AsyncServletDecorator.mapException(throwable -> {
            if (throwable instanceof HttpError) {
                int code = ((HttpError)throwable).getCode();
                return code >= 500 && code < 600;
            }
            return false;
        }, fallbackServlet);
    }

    public static AsyncServletDecorator mapToHttp500Exception() {
        return AsyncServletDecorator.mapToHttpException((Throwable e) -> HttpError.internalServerError500());
    }

    public static AsyncServletDecorator mapToHttpException(Function<Throwable, HttpError> fn) {
        return servlet -> request -> servlet.serveAsync(request).thenEx((response, e) -> {
            if (e == null) {
                return Promise.of((Object)response);
            }
            if (e instanceof HttpError) {
                return Promise.ofException((Throwable)e);
            }
            return Promise.ofException((Throwable)((Throwable)fn.apply((Throwable)e)));
        });
    }

    public static AsyncServletDecorator mapToHttpException(BiFunction<HttpRequest, Throwable, HttpError> fn) {
        return servlet -> request -> servlet.serveAsync(request).thenEx((response, e) -> {
            if (e == null) {
                return Promise.of((Object)response);
            }
            if (e instanceof HttpError) {
                return Promise.ofException((Throwable)e);
            }
            return Promise.ofException((Throwable)((Throwable)fn.apply(request, (Throwable)e)));
        });
    }

    public static AsyncServletDecorator catchUncheckedExceptions() {
        return servlet -> request -> {
            try {
                return servlet.serve(request);
            }
            catch (UncheckedException u) {
                return Promise.ofException((Throwable)u.getCause());
            }
        };
    }

    public static AsyncServletDecorator catchRuntimeExceptions() {
        return servlet -> request -> {
            try {
                return servlet.serve(request);
            }
            catch (UncheckedException u) {
                return Promise.ofException((Throwable)u.getCause());
            }
            catch (RuntimeException e) {
                return Promise.ofException((Throwable)e);
            }
        };
    }

    public static AsyncServletDecorator setMaxBodySize(MemSize maxBodySize) {
        return AsyncServletDecorator.setMaxBodySize(maxBodySize.toInt());
    }

    public static AsyncServletDecorator setMaxBodySize(int maxBodySize) {
        return servlet -> request -> {
            request.setMaxBodySize(maxBodySize);
            return servlet.serve(request);
        };
    }

    public static AsyncServletDecorator loadBody() {
        return servlet -> request -> request.loadBody().then(() -> servlet.serveAsync(request));
    }

    public static AsyncServletDecorator loadBody(MemSize maxBodySize) {
        return servlet -> request -> request.loadBody(maxBodySize).then(() -> servlet.serveAsync(request));
    }

    public static AsyncServletDecorator loadBody(int maxBodySize) {
        return servlet -> request -> request.loadBody(maxBodySize).then(() -> servlet.serveAsync(request));
    }

    public static AsyncServletDecorator logged() {
        return LoggableServlet::create;
    }

    public static AsyncServletDecorator logged(BiFunction<HttpRequest, @Nullable HttpResponse, String> loggerFunction) {
        return servlet -> LoggableServlet.create(servlet, loggerFunction);
    }
}

