/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.http.HttpUtils;
import java.lang.reflect.Array;
import org.jetbrains.annotations.Nullable;

public final class CaseInsensitiveTokenMap<T extends Token> {
    protected final T[] tokens;
    protected final int maxProbings;
    private final TokenFactory<T> factory;

    protected CaseInsensitiveTokenMap(int slotsNumber, int maxProbings, Class<T> elementsType, TokenFactory<T> factory) {
        Checks.checkArgument((Integer.bitCount(slotsNumber) == 1 ? 1 : 0) != 0);
        this.maxProbings = maxProbings;
        this.factory = factory;
        this.tokens = (Token[])Array.newInstance(elementsType, slotsNumber);
    }

    public final T register(String name) {
        T token = this.create(name);
        for (int p = 0; p < this.maxProbings; ++p) {
            int slot = ((Token)token).hashCodeCI + p & this.tokens.length - 1;
            if (this.tokens[slot] != null) continue;
            this.tokens[slot] = token;
            return token;
        }
        throw new IllegalArgumentException("CaseInsensitiveTokenMap hash collision, try to increase size");
    }

    public final T create(String name) {
        byte[] bytes = ByteBufStrings.encodeAscii((String)name);
        byte[] lowerCase = new byte[bytes.length];
        int hashCodeCI = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            lowerCase[i] = b >= 65 && b <= 90 ? (byte)(b + 97 - 65) : b;
            hashCodeCI += b | 0x20;
        }
        return (T)((Token)this.factory.create(hashCodeCI, bytes, 0, bytes.length, lowerCase));
    }

    public final T getOrCreate(byte[] bytes, int offset, int length) {
        int hashCodeCI = HttpUtils.hashCodeCI(bytes, offset, length);
        return this.getOrCreate(hashCodeCI, bytes, offset, length);
    }

    public final T getOrCreate(int hashCodeCI, byte[] bytes, int offset, int length) {
        T t = this.get(hashCodeCI, bytes, offset, length);
        return (T)(t != null ? t : (Token)this.factory.create(hashCodeCI, bytes, offset, length, null));
    }

    public final T get(int hashCodeCI, byte[] array, int offset, int length) {
        int slot = hashCodeCI & this.tokens.length - 1;
        T t = this.tokens[slot];
        if (t == null) {
            return null;
        }
        byte[] bytes = ((Token)t).bytes;
        if (((Token)t).hashCodeCI == hashCodeCI && bytes.length == length) {
            for (int i = 0; i < length; ++i) {
                if (array[offset + i] == bytes[i]) continue;
                if (CaseInsensitiveTokenMap.equalsLowerCase(i, ((Token)t).lowerCase, array, offset, length)) {
                    return t;
                }
                return this.probeNext(hashCodeCI, array, offset, length);
            }
            return t;
        }
        return this.probeNext(hashCodeCI, array, offset, length);
    }

    private T probeNext(int hashCodeCI, byte[] array, int offset, int length) {
        int slot;
        T t;
        block0: for (int p = 1; p < this.maxProbings && (t = this.tokens[slot = hashCodeCI + p & this.tokens.length - 1]) != null; ++p) {
            byte[] bytes = ((Token)t).bytes;
            if (((Token)t).hashCodeCI != hashCodeCI || bytes.length != length) continue;
            for (int i = 0; i < length; ++i) {
                if (array[offset + i] == bytes[i]) continue;
                if (!CaseInsensitiveTokenMap.equalsLowerCase(i, ((Token)t).lowerCase, array, offset, length)) continue block0;
                return t;
            }
            return t;
        }
        return null;
    }

    private static boolean equalsLowerCase(int i, byte[] lowerCase, byte[] array, int offset, int length) {
        assert (lowerCase.length == length);
        while (i < length) {
            if (array[offset + i] != lowerCase[i]) {
                return CaseInsensitiveTokenMap.equalsCaseInsensitive(i, lowerCase, array, offset, length);
            }
            ++i;
        }
        return true;
    }

    private static boolean equalsCaseInsensitive(int i, byte[] lowerCase, byte[] array, int offset, int length) {
        assert (lowerCase.length == length);
        while (i < length) {
            byte b = array[offset + i];
            byte p = lowerCase[i];
            if (b != p && (b < 65 || b > 90 || b + 32 != p)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @FunctionalInterface
    public static interface TokenFactory<T> {
        public T create(int var1, byte[] var2, int var3, int var4, @Nullable byte[] var5);
    }

    public static abstract class Token {
        protected final int hashCodeCI;
        protected final byte[] bytes;
        protected final int offset;
        protected final int length;
        @Nullable
        protected final byte[] lowerCase;

        protected Token(int hashCodeCI, byte[] bytes, int offset, int length, @Nullable byte[] lowerCase) {
            this.hashCodeCI = hashCodeCI;
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
            this.lowerCase = lowerCase;
        }
    }
}

