/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.exception.AsyncTimeoutException;
import io.activej.http.AbstractHttpConnection;
import org.jetbrains.annotations.Nullable;

final class ConnectionsLinkedList {
    private int size;
    @Nullable
    private AbstractHttpConnection first;
    @Nullable
    private AbstractHttpConnection last;

    ConnectionsLinkedList() {
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.size;
    }

    public void addLastNode(AbstractHttpConnection node) {
        ++this.size;
        if (this.last != null) {
            this.last.next = node;
            node.prev = this.last;
        } else {
            this.first = node;
        }
        this.last = node;
    }

    public void removeNode(AbstractHttpConnection node) {
        --this.size;
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            this.first = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.last = node.prev;
        }
        node.prev = null;
        node.next = null;
    }

    public int closeExpiredConnections(long expiration) {
        return this.closeExpiredConnections(expiration, null);
    }

    public int closeExpiredConnections(long expiration, @Nullable AsyncTimeoutException e) {
        int count = 0;
        AbstractHttpConnection connection = this.first;
        while (connection != null) {
            AbstractHttpConnection next = connection.next;
            if (connection.poolTimestamp > expiration) break;
            if (e == null) {
                connection.close();
            } else {
                connection.closeWithError((Throwable)e);
            }
            assert (connection.prev == null && connection.next == null);
            connection = next;
            ++count;
        }
        return count;
    }

    public void closeAllConnections() {
        AbstractHttpConnection connection = this.first;
        while (connection != null) {
            AbstractHttpConnection next = connection.next;
            connection.close();
            assert (connection.prev == null && connection.next == null);
            connection = next;
        }
    }

    public String toString() {
        return "ConnectionsLinkedList{size=" + this.size + '}';
    }
}

