/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.http.ContentTypes;
import io.activej.http.HttpCharset;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;
import java.nio.charset.Charset;
import java.util.Objects;

public final class ContentType {
    private static final byte[] CHARSET_KEY = ByteBufStrings.encodeAscii((String)"charset");
    final MediaType mime;
    final HttpCharset charset;

    ContentType(MediaType mime, HttpCharset charset) {
        this.mime = mime;
        this.charset = charset;
    }

    public static ContentType of(MediaType mime) {
        return new ContentType(mime, null);
    }

    public static ContentType of(MediaType mime, Charset charset) {
        return ContentTypes.lookup(mime, HttpCharset.of(charset));
    }

    static ContentType decode(byte[] bytes, int pos, int length) throws MalformedHttpException {
        try {
            int end = pos + length;
            int start = pos = HttpUtils.skipSpaces(bytes, pos, end);
            int hashCodeCI = 0;
            while (pos < end && bytes[pos] != 59) {
                byte b = bytes[pos++];
                hashCodeCI += b | 0x20;
            }
            MediaType type = MediaTypes.of(hashCodeCI, bytes, start, pos - start);
            HttpCharset charset = null;
            if (++pos < end) {
                start = pos = HttpUtils.skipSpaces(bytes, pos, end);
                while (pos < end) {
                    if (bytes[pos] == 61 && ByteBufStrings.equalsLowerCaseAscii((byte[])CHARSET_KEY, (byte[])bytes, (int)start, (int)(pos - start))) {
                        start = ++pos;
                        while (pos < end && bytes[pos] != 59) {
                            ++pos;
                        }
                        charset = HttpCharset.decode(bytes, start, pos - start);
                    } else if (bytes[pos] == 59 && pos + 1 < end) {
                        start = HttpUtils.skipSpaces(bytes, pos + 1, end);
                    }
                    ++pos;
                }
            }
            return ContentTypes.lookup(type, charset);
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode content-type", e);
        }
    }

    static void render(ContentType type, ByteBuf buf) {
        int pos = ContentType.render(type, buf.array(), buf.tail());
        buf.tail(pos);
    }

    static int render(ContentType type, byte[] container, int pos) {
        pos += MediaTypes.render(type.getMediaType(), container, pos);
        if (type.charset != null) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte b : CHARSET_KEY) {
                container[pos++] = b;
            }
            container[pos++] = 61;
            pos += HttpCharset.render(type.charset, container, pos);
        }
        return pos;
    }

    public Charset getCharset() throws MalformedHttpException {
        return this.charset == null ? null : this.charset.toJavaCharset();
    }

    public MediaType getMediaType() {
        return this.mime;
    }

    int size() {
        int size = this.mime.size();
        if (this.charset != null) {
            size += this.charset.size();
            size += 10;
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType that = (ContentType)o;
        return this.mime.equals(that.mime) && Objects.equals(this.charset, that.charset);
    }

    public int hashCode() {
        int result = this.mime.hashCode();
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ContentType{type=" + this.mime + ", charset=" + this.charset + '}';
    }
}

