/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.http.ContentType;
import io.activej.http.HttpCharset;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;

public final class ContentTypes {
    public static final ContentType ANY_TEXT_UTF_8 = ContentTypes.register(MediaTypes.ANY_TEXT, HttpCharset.UTF_8);
    public static final ContentType PLAIN_TEXT_UTF_8 = ContentTypes.register(MediaTypes.PLAIN_TEXT, HttpCharset.UTF_8);
    public static final ContentType JSON_UTF_8 = ContentTypes.register(MediaTypes.JSON, HttpCharset.UTF_8);
    public static final ContentType HTML_UTF_8 = ContentTypes.register(MediaTypes.HTML, HttpCharset.UTF_8);
    public static final ContentType CSS_UTF_8 = ContentTypes.register(MediaTypes.CSS, HttpCharset.UTF_8);
    public static final ContentType PLAIN_TEXT_ASCII = ContentTypes.register(MediaTypes.PLAIN_TEXT, HttpCharset.US_ASCII);

    static ContentType lookup(MediaType mime, HttpCharset charset) {
        if (mime == MediaTypes.JSON && charset == HttpCharset.UTF_8) {
            return JSON_UTF_8;
        }
        return new ContentType(mime, charset);
    }

    static ContentType register(MediaType mime, HttpCharset charset) {
        return new ContentType(mime, charset);
    }
}

