/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.process.AsyncCloseable;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.ApplicationSettings;
import io.activej.common.Utils;
import io.activej.common.exception.CloseException;
import io.activej.common.recycle.Recyclable;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.ChannelSuppliers;
import io.activej.csp.dsl.ChannelConsumerTransformer;
import io.activej.csp.dsl.ChannelSupplierTransformer;
import io.activej.csp.queue.ChannelZeroBuffer;
import io.activej.eventloop.Eventloop;
import io.activej.http.AbstractHttpConnection;
import io.activej.http.AddressLinkedList;
import io.activej.http.AsyncHttpClient;
import io.activej.http.HttpException;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import io.activej.http.HttpVersion;
import io.activej.http.MalformedHttpException;
import io.activej.http.PoolLabel;
import io.activej.http.WebSocket;
import io.activej.http.WebSocketBufsToFrames;
import io.activej.http.WebSocketConstants;
import io.activej.http.WebSocketFramesToBufs;
import io.activej.http.WebSocketImpl;
import io.activej.http.stream.BufsConsumerGzipInflater;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import io.activej.promise.CompleteNullPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpClientConnection
extends AbstractHttpConnection {
    private static final boolean DETAILED_ERROR_MESSAGES = ApplicationSettings.getBoolean(HttpClientConnection.class, (String)"detailedErrorMessages", (boolean)false);
    static final HttpHeaderValue CONNECTION_UPGRADE_HEADER = HttpHeaderValue.ofBytes(ByteBufStrings.encodeAscii((String)"upgrade"));
    static final HttpHeaderValue UPGRADE_WEBSOCKET_HEADER = HttpHeaderValue.ofBytes(ByteBufStrings.encodeAscii((String)"websocket"));
    @Nullable
    private SettablePromise<HttpResponse> promise;
    @Nullable
    private HttpResponse response;
    private final AsyncHttpClient client;
    @Nullable
    private final AsyncHttpClient.Inspector inspector;
    final InetSocketAddress remoteAddress;
    @Nullable
    HttpClientConnection addressPrev;
    HttpClientConnection addressNext;

    HttpClientConnection(Eventloop eventloop, AsyncHttpClient client, AsyncTcpSocket asyncTcpSocket, InetSocketAddress remoteAddress) {
        super(eventloop, asyncTcpSocket, client.maxBodySize);
        this.client = client;
        this.inspector = client.inspector;
        this.remoteAddress = remoteAddress;
    }

    public PoolLabel getCurrentPool() {
        if (this.pool == this.client.poolKeepAlive) {
            return PoolLabel.KEEP_ALIVE;
        }
        if (this.pool == this.client.poolReadWrite) {
            return PoolLabel.READ_WRITE;
        }
        return PoolLabel.NONE;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    protected void readMessage() throws MalformedHttpException {
        this.readStartLine();
    }

    @Override
    protected void onClosedWithError(@NotNull Throwable e) {
        if (this.inspector != null) {
            this.inspector.onHttpError(this, e);
        }
        if (this.promise != null) {
            SettablePromise<HttpResponse> promise = this.promise;
            this.promise = null;
            promise.setException(e);
        }
    }

    @Override
    protected void onStartLine(byte[] line, int pos, int limit) throws MalformedHttpException {
        boolean http11;
        boolean http1x = line[pos + 0] == 72 && line[pos + 1] == 84 && line[pos + 2] == 84 && line[pos + 3] == 80 && line[pos + 4] == 47 && line[pos + 5] == 49;
        boolean bl = http11 = line[pos + 6] == 46 && line[pos + 7] == 49 && line[pos + 8] == 32;
        if (!http1x) {
            if (!DETAILED_ERROR_MESSAGES) {
                throw new MalformedHttpException("Invalid response");
            }
            throw new MalformedHttpException("Invalid response. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
        }
        int i = pos + 9;
        HttpVersion version = HttpVersion.HTTP_1_1;
        if (http11) {
            this.flags = (byte)(this.flags | 1);
        } else if (line[6] == 46 && line[7] == 48 && line[8] == 32) {
            version = HttpVersion.HTTP_1_0;
        } else if (line[6] == 32) {
            version = HttpVersion.HTTP_1_0;
            i -= 2;
        } else {
            if (!DETAILED_ERROR_MESSAGES) {
                throw new MalformedHttpException("Invalid response");
            }
            throw new MalformedHttpException("Invalid response. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
        }
        int statusCode = HttpUtils.decodePositiveInt(line, i, 3);
        if (statusCode < 100 || statusCode >= 600) {
            throw new MalformedHttpException("Invalid HTTP Status Code " + statusCode);
        }
        this.response = new HttpResponse(version, statusCode, this);
        this.response.maxBodySize = this.maxBodySize;
        if (statusCode < 200 || statusCode == 204 || statusCode == 304) {
            this.contentLength = 0;
        }
    }

    @Override
    protected void onHeader(HttpHeader header, byte[] array, int off, int len) throws MalformedHttpException {
        assert (this.response != null);
        if (this.response.headers.size() >= MAX_HEADERS) {
            throw new MalformedHttpException("Too many headers");
        }
        this.response.addHeader(header, array, off, len);
    }

    @Override
    protected void onHeadersReceived(@Nullable ByteBuf body, @Nullable ChannelSupplier<ByteBuf> bodySupplier) {
        assert (!this.isClosed());
        HttpResponse response = this.response;
        response.flags = (byte)(response.flags | 1);
        response.body = body;
        ChannelSupplier channelSupplier = response.bodyStream = bodySupplier == null ? null : this.sanitize(bodySupplier);
        if (WebSocket.ENABLED && this.isWebSocket() && !this.processWebSocketResponse(body)) {
            return;
        }
        if (this.inspector != null) {
            this.inspector.onHttpResponse(response);
        }
        SettablePromise<HttpResponse> promise = this.promise;
        this.promise = null;
        promise.set((Object)response);
    }

    private boolean processWebSocketResponse(@Nullable ByteBuf body) {
        if (this.response.getCode() == 101) {
            assert (body != null && body.readRemaining() == 0);
            this.response.bodyStream = this.sanitize((ChannelSupplier<ByteBuf>)ChannelSuppliers.concat((ChannelSupplier)ChannelSupplier.of((Object)this.detachReadBuf()), (ChannelSupplier)ChannelSupplier.ofSocket((AsyncTcpSocket)this.socket)));
            return true;
        }
        this.closeWithError(WebSocketConstants.HANDSHAKE_FAILED);
        return false;
    }

    @Override
    protected void onBodyReceived() {
        assert (!this.isClosed());
        this.flags = (byte)(this.flags | 0x10);
        if (this.response != null && (this.flags & 0x20) != 0) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onBodySent() {
        assert (!this.isClosed());
        this.flags = (byte)(this.flags | 0x20);
        if (this.response != null && (this.flags & 0x10) != 0) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onNoContentLength() {
        ChannelZeroBuffer buffer = new ChannelZeroBuffer();
        ChannelSupplier supplier = ChannelSuppliers.concat((ChannelSupplier)ChannelSupplier.of((Object)this.detachReadBuf()), (ChannelSupplier)buffer.getSupplier());
        CompleteNullPromise inflaterFinished = Promise.complete();
        if ((this.flags & 2) != 0) {
            BufsConsumerGzipInflater gzipInflater = BufsConsumerGzipInflater.create();
            supplier = (ChannelSupplier)supplier.transformWith((ChannelSupplierTransformer)gzipInflater);
            inflaterFinished = gzipInflater.getProcessCompletion();
        }
        this.onHeadersReceived(null, (ChannelSupplier<ByteBuf>)supplier);
        ChannelSupplier.of(() -> ((AsyncTcpSocket)this.socket).read(), (AsyncCloseable)this.socket).streamTo(buffer.getConsumer()).both((Promise)inflaterFinished).whenComplete(($, e) -> {
            if (this.isClosed()) {
                return;
            }
            if (e == null) {
                this.onBodyReceived();
            } else {
                this.closeWithError(HttpUtils.translateToHttpException(e));
            }
        });
    }

    @NotNull
    Promise<WebSocket> sendWebSocketRequest(HttpRequest request) {
        SettablePromise promise;
        assert (!this.isClosed());
        this.promise = promise = new SettablePromise();
        this.pool = this.client.poolReadWrite;
        this.pool.addLastNode(this);
        this.poolTimestamp = this.eventloop.currentTimeMillis();
        this.flags = (byte)(this.flags | 8);
        byte[] encodedKey = HttpUtils.generateWebSocketKey();
        request.addHeader(HttpHeaders.SEC_WEBSOCKET_KEY, encodedKey);
        ChannelZeroBuffer buffer = new ChannelZeroBuffer();
        request.bodyStream = this.sanitize((ChannelSupplier<ByteBuf>)buffer.getSupplier());
        this.writeHttpMessageAsStream(null, request);
        if (!this.isClosed()) {
            this.readHttpResponse();
        }
        return promise.then(res -> {
            assert (res.getCode() == 101);
            if (HttpUtils.isAnswerInvalid(res, encodedKey)) {
                this.closeWithError(WebSocketConstants.HANDSHAKE_FAILED);
                return Promise.ofException((Throwable)WebSocketConstants.HANDSHAKE_FAILED);
            }
            int maxWebSocketMessageSize = this.client.maxWebSocketMessageSize;
            WebSocketFramesToBufs encoder = WebSocketFramesToBufs.create(true);
            WebSocketBufsToFrames decoder = WebSocketBufsToFrames.create(maxWebSocketMessageSize, encoder::sendPong, ByteBuf::recycle, false);
            this.bindWebSocketTransformers(encoder, decoder);
            return Promise.of((Object)new WebSocketImpl(request, (HttpResponse)res, (ChannelSupplier<WebSocket.Frame>)((ChannelSupplier)res.getBodyStream().transformWith((ChannelSupplierTransformer)decoder)), (ChannelConsumer<WebSocket.Frame>)((ChannelConsumer)buffer.getConsumer().transformWith((ChannelConsumerTransformer)encoder)), decoder::onProtocolError, maxWebSocketMessageSize));
        }).whenException(e -> this.closeWithError(HttpUtils.translateToHttpException(e)));
    }

    private void bindWebSocketTransformers(WebSocketFramesToBufs encoder, WebSocketBufsToFrames decoder) {
        encoder.getCloseSentPromise().then(decoder::getCloseReceivedPromise).whenException(this::closeWebSocketConnection).whenResult(this::closeWebSocketConnection);
        decoder.getProcessCompletion().whenComplete(($, e) -> {
            if (this.isClosed()) {
                return;
            }
            if (e == null) {
                encoder.sendCloseFrame(WebSocketConstants.REGULAR_CLOSE);
            } else {
                encoder.closeEx(e);
            }
        });
    }

    private void readHttpResponse() {
        this.contentLength = -1;
        if (this.readBuf == null) {
            this.read();
        } else {
            this.eventloop.post(() -> {
                if (this.isClosed()) {
                    return;
                }
                this.read();
            });
        }
    }

    private void onHttpMessageComplete() {
        if (WebSocket.ENABLED && this.isWebSocket()) {
            return;
        }
        this.response.recycle();
        this.response = null;
        if (this.stashedBufs != null) {
            this.stashedBufs.recycle();
            this.stashedBufs = null;
        }
        if (this.readBuf != null && !this.readBuf.canRead()) {
            this.readBuf.recycle();
            this.readBuf = null;
        }
        if ((this.flags & 1) != 0 && this.client.keepAliveTimeoutMillis != 0 && this.contentLength != -1) {
            this.flags = 0;
            this.socket.read().whenComplete((buf, e) -> {
                if (e == null) {
                    if (buf != null) {
                        buf.recycle();
                        this.closeWithError(new HttpException("Unexpected read data"));
                    } else {
                        this.close();
                    }
                } else {
                    this.closeWithError(HttpUtils.translateToHttpException(e));
                }
            });
            if (this.isClosed()) {
                return;
            }
            this.client.returnToKeepAlivePool(this);
        } else {
            this.close();
        }
    }

    Promise<HttpResponse> send(HttpRequest request) {
        SettablePromise promise;
        assert (!this.isClosed());
        this.promise = promise = new SettablePromise();
        this.pool = this.client.poolReadWrite;
        this.pool.addLastNode(this);
        this.poolTimestamp = this.eventloop.currentTimeMillis();
        HttpHeaderValue connectionHeader = CONNECTION_KEEP_ALIVE_HEADER;
        if (++this.numberOfRequests >= this.client.maxKeepAliveRequests && this.client.maxKeepAliveRequests != 0 || this.client.keepAliveTimeoutMillis == 0) {
            connectionHeader = CONNECTION_CLOSE_HEADER;
        }
        request.addHeader(HttpHeaders.CONNECTION, connectionHeader);
        ByteBuf buf = HttpClientConnection.renderHttpMessage(request);
        if (buf != null) {
            this.writeBuf(buf);
        } else {
            this.writeHttpMessageAsStream(null, request);
        }
        if (!this.isClosed()) {
            this.readHttpResponse();
        }
        return promise;
    }

    @Override
    protected void onClosed() {
        if (this.inspector != null) {
            this.inspector.onDisconnect(this);
        }
        if (this.promise != null) {
            SettablePromise<HttpResponse> promise = this.promise;
            this.promise = null;
            promise.setException((Throwable)new CloseException("Connection closed"));
        }
        if (this.pool == this.client.poolKeepAlive) {
            AddressLinkedList addresses = this.client.addresses.get(this.remoteAddress);
            addresses.removeNode(this);
            if (addresses.isEmpty()) {
                this.client.addresses.remove(this.remoteAddress);
            }
        }
        this.pool.removeNode(this);
        this.client.onConnectionClosed();
        this.response = (HttpResponse)Utils.nullify((Object)this.response, HttpMessage::recycle);
        this.readBuf = (ByteBuf)Utils.nullify((Object)this.readBuf, ByteBuf::recycle);
        this.stashedBufs = (Recyclable)Utils.nullify((Object)this.stashedBufs, Recyclable::recycle);
    }

    @Override
    public String toString() {
        return "HttpClientConnection{pool=" + (Object)((Object)this.getCurrentPool()) + ", promise=" + this.promise + ", response=" + this.response + ", httpClient=" + this.client + ", remoteAddress=" + this.remoteAddress + ',' + super.toString() + '}';
    }
}

