/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBufStrings;
import io.activej.http.CaseInsensitiveTokenMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpHeader
extends CaseInsensitiveTokenMap.Token {
    HttpHeader(int hashCodeCI, byte[] bytes, int offset, int length, @Nullable byte[] lowerCaseBytes) {
        super(hashCodeCI, bytes, offset, length, lowerCaseBytes);
    }

    public int size() {
        return this.length;
    }

    public int writeTo(byte[] array, int offset) {
        System.arraycopy(this.bytes, this.offset, array, offset, this.length);
        return this.length + offset;
    }

    public int hashCode() {
        return this.hashCodeCI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpHeader)) {
            return false;
        }
        HttpHeader that = (HttpHeader)o;
        if (this.length != that.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            byte thisChar = this.bytes[this.offset + i];
            byte thatChar = that.bytes[that.offset + i];
            if (thisChar >= 65 && thisChar <= 90) {
                thisChar = (byte)(thisChar + 32);
            }
            if (thatChar >= 65 && thatChar <= 90) {
                thatChar = (byte)(thatChar + 32);
            }
            if (thisChar == thatChar) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return ByteBufStrings.decodeAscii((byte[])this.bytes, (int)this.offset, (int)this.length);
    }
}

