/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.ApplicationSettings;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpHeadersMultimap<K, V> {
    static final int INITIAL_SIZE = ApplicationSettings.getInt(HttpHeadersMultimap.class, (String)"initialSize", (int)8);
    Object[] kvPairs = new Object[INITIAL_SIZE];
    int size;

    HttpHeadersMultimap() {
    }

    @Contract(pure=true)
    public int size() {
        return this.size;
    }

    public void add(@NotNull K key, @NotNull V value) {
        if (this.size++ > this.kvPairs.length / 4) {
            this.resize();
        }
        int i = key.hashCode() & this.kvPairs.length - 2;
        while (true) {
            if (this.kvPairs[i] == null) {
                this.kvPairs[i] = key;
                this.kvPairs[i + 1] = value;
                return;
            }
            i = i + 2 & this.kvPairs.length - 2;
        }
    }

    private void resize() {
        Object[] oldKvPairs = this.kvPairs;
        this.kvPairs = new Object[this.kvPairs.length * 4];
        for (int i = 0; i != oldKvPairs.length; i += 2) {
            Object k = oldKvPairs[i];
            if (k == null) continue;
            Object v = oldKvPairs[i + 1];
            this.add(k, v);
        }
    }

    @Nullable
    @Contract(pure=true)
    public V get(@NotNull K key) {
        int i = key.hashCode() & this.kvPairs.length - 2;
        Object k;
        while ((k = this.kvPairs[i]) != null) {
            if (k.equals(key)) {
                return (V)this.kvPairs[i + 1];
            }
            i = i + 2 & this.kvPairs.length - 2;
        }
        return null;
    }

    public final Collection<Map.Entry<K, V>> getEntries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return HttpHeadersMultimap.this.size;
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    int i = 0;
                    @Nullable
                    K k;
                    @Nullable
                    V v;
                    {
                        this.advance();
                    }

                    private void advance() {
                        while (this.i < HttpHeadersMultimap.this.kvPairs.length) {
                            Object k = HttpHeadersMultimap.this.kvPairs[this.i];
                            if (k != null) {
                                this.k = k;
                                this.v = HttpHeadersMultimap.this.kvPairs[this.i + 1];
                                this.i += 2;
                                return;
                            }
                            this.i += 2;
                        }
                        this.k = null;
                        this.v = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.k != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.k == null) {
                            throw new NoSuchElementException();
                        }
                        AbstractMap.SimpleImmutableEntry entry = new AbstractMap.SimpleImmutableEntry(this.k, this.v);
                        this.advance();
                        return entry;
                    }
                };
            }
        };
    }

    public String toString() {
        return Arrays.toString(this.kvPairs);
    }
}

