/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.Utils;
import io.activej.common.exception.UncheckedException;
import io.activej.csp.ChannelConsumers;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.ChannelSuppliers;
import io.activej.http.HttpCookie;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeadersMultimap;
import io.activej.http.HttpVersion;
import io.activej.http.MalformedHttpException;
import io.activej.promise.Promise;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpMessage {
    private static final boolean CHECK = Checks.isEnabled(HttpMessage.class);
    static final byte MUST_LOAD_BODY = 1;
    static final byte USE_GZIP = 2;
    static final byte RECYCLED = -128;
    private final HttpVersion version;
    byte flags;
    final HttpHeadersMultimap<HttpHeader, HttpHeaderValue> headers = new HttpHeadersMultimap();
    @Nullable
    ByteBuf body;
    @Nullable
    ChannelSupplier<ByteBuf> bodyStream;
    protected int maxBodySize;
    protected Map<Object, Object> attachments;

    protected HttpMessage(HttpVersion version) {
        this.version = version;
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public void addHeader(@NotNull HttpHeader header, @NotNull String string) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.addHeader(header, HttpHeaderValue.of(string));
    }

    public void addHeader(@NotNull HttpHeader header, @NotNull byte[] value) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.addHeader(header, HttpHeaderValue.ofBytes(value, 0, value.length));
    }

    public void addHeader(@NotNull HttpHeader header, @NotNull byte[] array, int off, int len) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.addHeader(header, HttpHeaderValue.ofBytes(array, off, len));
    }

    public void addHeader(@NotNull HttpHeader header, @NotNull HttpHeaderValue value) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.headers.add(header, value);
    }

    public final Collection<Map.Entry<HttpHeader, HttpHeaderValue>> getHeaders() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.headers.getEntries();
    }

    @NotNull
    public final <T> List<T> getHeader(@NotNull HttpHeader header, @NotNull HttpHeaderValue.DecoderIntoList<T> decoder) {
        HttpHeader k;
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        ArrayList list = new ArrayList();
        int i = header.hashCode() & this.headers.kvPairs.length - 2;
        while ((k = (HttpHeader)this.headers.kvPairs[i]) != null) {
            if (k.equals(header)) {
                try {
                    decoder.decode(((HttpHeaderValue)this.headers.kvPairs[i + 1]).getBuf(), list);
                }
                catch (MalformedHttpException malformedHttpException) {
                    // empty catch block
                }
            }
            i = i + 2 & this.headers.kvPairs.length - 2;
        }
        return list;
    }

    @Nullable
    public <T> T getHeader(HttpHeader header, HttpDecoderFunction<T> decoder) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        try {
            ByteBuf buf = this.getHeaderBuf(header);
            if (buf != null) {
                return decoder.decode(buf);
            }
        }
        catch (MalformedHttpException malformedHttpException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public final String getHeader(@NotNull HttpHeader header) {
        HttpHeaderValue headerValue;
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return (headerValue = this.headers.get(header)) != null ? headerValue.toString() : null;
    }

    @Nullable
    public final ByteBuf getHeaderBuf(@NotNull HttpHeader header) {
        HttpHeaderValue headerBuf;
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return (headerBuf = this.headers.get(header)) != null ? headerBuf.getBuf() : null;
    }

    public void addCookies(HttpCookie ... cookies) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.addCookies(Arrays.asList(cookies));
    }

    public abstract void addCookies(@NotNull List<HttpCookie> var1);

    public abstract void addCookie(@NotNull HttpCookie var1);

    public void setBodyStream(@NotNull ChannelSupplier<ByteBuf> bodySupplier) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.bodyStream = bodySupplier;
    }

    public ChannelSupplier<ByteBuf> getBodyStream() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        ChannelSupplier<ByteBuf> bodyStream = this.bodyStream;
        this.bodyStream = null;
        if (bodyStream != null) {
            return bodyStream;
        }
        if (this.body != null) {
            ByteBuf body = this.body;
            this.body = null;
            return ChannelSupplier.of((Object)body);
        }
        throw new IllegalStateException("Body stream is missing or already consumed");
    }

    public void setBody(@NotNull ByteBuf body) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.body = body;
    }

    public void setBody(@NotNull byte[] body) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.setBody(ByteBuf.wrapForReading((byte[])body));
    }

    public final ByteBuf getBody() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if ((this.flags & 1) != 0) {
            throw new IllegalStateException("Body is not loaded");
        }
        if (this.body != null) {
            return this.body;
        }
        throw new IllegalStateException("Body is missing or already consumed");
    }

    public final ByteBuf takeBody() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        ByteBuf body = this.getBody();
        this.body = null;
        return body;
    }

    public final boolean isBodyLoaded() {
        return (this.flags & 1) == 0 && this.body != null;
    }

    public void setMaxBodySize(MemSize maxBodySize) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.maxBodySize = maxBodySize.toInt();
    }

    public void setMaxBodySize(int maxBodySize) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.maxBodySize = maxBodySize;
    }

    public Promise<ByteBuf> loadBody() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.loadBody(this.maxBodySize);
    }

    public Promise<ByteBuf> loadBody(@NotNull MemSize maxBodySize) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.loadBody(maxBodySize.toInt());
    }

    public Promise<ByteBuf> loadBody(int maxBodySize) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.body != null) {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            return Promise.of((Object)this.body);
        }
        ChannelSupplier<ByteBuf> bodyStream = this.bodyStream;
        if (bodyStream == null) {
            throw new IllegalStateException("Body stream is missing or already consumed");
        }
        this.bodyStream = null;
        return ChannelSuppliers.collect(bodyStream, (Object)new ByteBufs(), (bufs, buf) -> {
            if (maxBodySize != 0 && bufs.hasRemainingBytes(maxBodySize)) {
                bufs.recycle();
                buf.recycle();
                throw new UncheckedException((Throwable)new MalformedHttpException("HTTP body size exceeds load limit " + maxBodySize));
            }
            bufs.add(buf);
        }, ByteBufs::takeRemaining).whenResult(body -> {
            assert (!this.isRecycled());
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.body = body;
        });
    }

    public <T> void attach(Type type, T extra) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.attachments == null) {
            this.attachments = new HashMap<Object, Object>();
        }
        this.attachments.put(type, extra);
    }

    public <T> void attach(Class<T> type, T extra) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.attachments == null) {
            this.attachments = new HashMap<Object, Object>();
        }
        this.attachments.put(type, extra);
    }

    public void attach(Object extra) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.attachments == null) {
            this.attachments = new HashMap<Object, Object>();
        }
        this.attachments.put(extra.getClass(), extra);
    }

    public <T> void attach(String key, T extra) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.attachments == null) {
            this.attachments = new HashMap<Object, Object>();
        }
        this.attachments.put(key, extra);
    }

    public <T> T getAttachment(Class<T> type) {
        if (this.attachments == null) {
            return null;
        }
        Object res = this.attachments.get(type);
        return (T)res;
    }

    public <T> T getAttachment(Type type) {
        if (this.attachments == null) {
            return null;
        }
        Object res = this.attachments.get(type);
        return (T)res;
    }

    public <T> T getAttachment(String key) {
        if (this.attachments == null) {
            return null;
        }
        Object res = this.attachments.get(key);
        return (T)res;
    }

    public Set<Object> getAttachmentKeys() {
        return this.attachments != null ? this.attachments.keySet() : Collections.emptySet();
    }

    public void setBodyGzipCompression() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.flags = (byte)(this.flags | 2);
    }

    boolean isRecycled() {
        return (this.flags & 0xFFFFFF80) != 0;
    }

    abstract boolean isContentLengthExpected();

    final void recycle() {
        if (this.isRecycled()) {
            return;
        }
        this.flags = (byte)(this.flags | 0xFFFFFF80);
        if (this.body != null) {
            this.body.recycle();
        }
        if (this.bodyStream != null) {
            this.bodyStream.streamTo(ChannelConsumers.recycling());
        }
    }

    void recycleBody() {
        this.body = (ByteBuf)Utils.nullify((Object)this.body, ByteBuf::recycle);
        this.bodyStream = (ChannelSupplier)Utils.nullify(this.bodyStream, stream -> stream.streamTo(ChannelConsumers.recycling()));
    }

    protected void writeHeaders(@NotNull ByteBuf buf) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        byte[] array = buf.array();
        int offset = buf.tail();
        for (int i = 0; i < this.headers.kvPairs.length - 1; i += 2) {
            HttpHeader k = (HttpHeader)this.headers.kvPairs[i];
            if (k == null) continue;
            HttpHeaderValue v = (HttpHeaderValue)this.headers.kvPairs[i + 1];
            array[offset++] = 13;
            array[offset++] = 10;
            offset = k.writeTo(array, offset);
            array[offset++] = 58;
            array[offset++] = 32;
            offset = v.writeTo(array, offset);
        }
        array[offset++] = 13;
        array[offset++] = 10;
        array[offset++] = 13;
        array[offset++] = 10;
        buf.tail(offset);
    }

    protected int estimateSize(int firstLineSize) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        int size = firstLineSize;
        for (int i = 0; i < this.headers.kvPairs.length - 1; i += 2) {
            HttpHeader k = (HttpHeader)this.headers.kvPairs[i];
            if (k == null) continue;
            HttpHeaderValue v = (HttpHeaderValue)this.headers.kvPairs[i + 1];
            size += 2 + k.size() + 2 + v.estimateSize();
        }
        return size += 4;
    }

    protected abstract int estimateSize();

    protected abstract void writeTo(@NotNull ByteBuf var1);

    public static interface HttpDecoderFunction<T> {
        public T decode(ByteBuf var1) throws MalformedHttpException;
    }
}

