/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.common.api.WithInitializer;
import io.activej.csp.ChannelSupplier;
import io.activej.http.AbstractHttpConnection;
import io.activej.http.HttpClientConnection;
import io.activej.http.HttpCookie;
import io.activej.http.HttpError;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpMethod;
import io.activej.http.HttpServerConnection;
import io.activej.http.HttpVersion;
import io.activej.http.MultipartDecoder;
import io.activej.http.Protocol;
import io.activej.http.QueryParameter;
import io.activej.http.UrlParser;
import io.activej.promise.Promise;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequest
extends HttpMessage
implements WithInitializer<HttpRequest> {
    private static final boolean CHECK = Checks.isEnabled(HttpRequest.class);
    private static final int LONGEST_HTTP_METHOD_SIZE = 12;
    private static final byte[] HTTP_1_1 = ByteBufStrings.encodeAscii((String)" HTTP/1.1");
    private static final int HTTP_1_1_SIZE = HTTP_1_1.length;
    private final HttpMethod method;
    private final UrlParser url;
    private final HttpServerConnection connection;
    private InetAddress remoteAddress;
    private Map<String, String> pathParameters;
    private Map<String, String> queryParameters;
    private Map<String, String> postParameters;
    @Nullable
    private Map<String, String> parsedCookies;

    HttpRequest(@NotNull HttpVersion version, @NotNull HttpMethod method, @NotNull UrlParser url, @Nullable HttpServerConnection connection) {
        super(version);
        this.method = method;
        this.url = url;
        this.connection = connection;
    }

    @NotNull
    public static HttpRequest of(@NotNull HttpMethod method, @NotNull String url) {
        Protocol protocol;
        UrlParser urlParser = UrlParser.of(url);
        HttpRequest request = new HttpRequest(HttpVersion.HTTP_1_1, method, urlParser, null);
        String hostAndPort = urlParser.getHostAndPort();
        if (hostAndPort != null) {
            request.headers.add(HttpHeaders.HOST, HttpHeaderValue.of(hostAndPort));
        }
        if ((protocol = urlParser.getProtocol()) == Protocol.WS || protocol == Protocol.WSS) {
            request.addHeader(HttpHeaders.CONNECTION, HttpClientConnection.CONNECTION_UPGRADE_HEADER);
            request.addHeader(HttpHeaders.UPGRADE, HttpClientConnection.UPGRADE_WEBSOCKET_HEADER);
            request.addHeader(HttpHeaders.SEC_WEBSOCKET_VERSION, AbstractHttpConnection.WEB_SOCKET_VERSION);
        }
        return request;
    }

    @NotNull
    public static HttpRequest get(@NotNull String url) {
        return HttpRequest.of(HttpMethod.GET, url);
    }

    @NotNull
    public static HttpRequest post(@NotNull String url) {
        return HttpRequest.of(HttpMethod.POST, url);
    }

    @NotNull
    public static HttpRequest put(@NotNull String url) {
        return HttpRequest.of(HttpMethod.PUT, url);
    }

    @NotNull
    public HttpRequest withHeader(@NotNull HttpHeader header, @NotNull String value) {
        this.addHeader(header, value);
        return this;
    }

    @NotNull
    public HttpRequest withHeader(@NotNull HttpHeader header, @NotNull byte[] value) {
        this.addHeader(header, value);
        return this;
    }

    @NotNull
    public HttpRequest withHeader(@NotNull HttpHeader header, @NotNull HttpHeaderValue value) {
        this.addHeader(header, value);
        return this;
    }

    @NotNull
    public HttpRequest withBody(@NotNull byte[] array) {
        this.setBody(array);
        return this;
    }

    @NotNull
    public HttpRequest withBody(@NotNull ByteBuf body) {
        this.setBody(body);
        return this;
    }

    @NotNull
    public HttpRequest withBodyStream(@NotNull ChannelSupplier<ByteBuf> stream) {
        this.setBodyStream(stream);
        return this;
    }

    @NotNull
    public HttpRequest withCookies(@NotNull List<HttpCookie> cookies) {
        this.addCookies(cookies);
        return this;
    }

    @NotNull
    public HttpRequest withCookies(HttpCookie ... cookie) {
        this.addCookies(cookie);
        return this;
    }

    @NotNull
    public HttpRequest withCookie(@NotNull HttpCookie cookie) {
        this.addCookie(cookie);
        return this;
    }

    @NotNull
    public HttpRequest withBodyGzipCompression() {
        this.setBodyGzipCompression();
        return this;
    }

    @Override
    public void addCookies(@NotNull List<HttpCookie> cookies) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.headers.add(HttpHeaders.COOKIE, new HttpHeaderValue.HttpHeaderValueOfSimpleCookies(cookies));
    }

    @Override
    public void addCookie(@NotNull HttpCookie cookie) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.addCookies(Collections.singletonList(cookie));
    }

    @NotNull
    @Contract(pure=true)
    public HttpMethod getMethod() {
        return this.method;
    }

    @Contract(pure=true)
    public InetAddress getRemoteAddress() {
        if (CHECK) {
            Checks.checkNotNull((Object)this.remoteAddress);
        }
        return this.remoteAddress;
    }

    void setRemoteAddress(@NotNull InetAddress inetAddress) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.remoteAddress = inetAddress;
    }

    public Protocol getProtocol() {
        return this.url.getProtocol();
    }

    void setProtocol(Protocol protocol) {
        this.url.setProtocol(protocol);
    }

    @Override
    boolean isContentLengthExpected() {
        return this.method != HttpMethod.GET && this.method != HttpMethod.HEAD && this.method != HttpMethod.TRACE && this.method != HttpMethod.CONNECT && this.method != HttpMethod.OPTIONS;
    }

    UrlParser getUrl() {
        return this.url;
    }

    @Nullable
    public String getHostAndPort() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getHostAndPort();
    }

    @NotNull
    public String getPath() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getPath();
    }

    @NotNull
    public String getPathAndQuery() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getPathAndQuery();
    }

    @NotNull
    public Map<String, String> getCookies() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.parsedCookies != null) {
            return this.parsedCookies;
        }
        LinkedHashMap<String, String> cookies = new LinkedHashMap<String, String>();
        for (HttpCookie cookie : this.getHeader(HttpHeaders.COOKIE, HttpHeaderValue::toSimpleCookies)) {
            cookies.put(cookie.getName(), cookie.getValue());
        }
        this.parsedCookies = cookies;
        return this.parsedCookies;
    }

    public HttpServerConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public String getCookie(@NotNull String cookie) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.getCookies().get(cookie);
    }

    @NotNull
    public String getQuery() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQuery();
    }

    @NotNull
    public String getFragment() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getFragment();
    }

    @NotNull
    public Map<String, String> getQueryParameters() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.queryParameters != null) {
            return this.queryParameters;
        }
        this.queryParameters = this.url.getQueryParameters();
        return this.queryParameters;
    }

    @Nullable
    public String getQueryParameter(@NotNull String key) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQueryParameter(key);
    }

    @NotNull
    public List<String> getQueryParameters(@NotNull String key) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQueryParameters(key);
    }

    @NotNull
    public Iterable<QueryParameter> getQueryParametersIterable() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQueryParametersIterable();
    }

    @Nullable
    public String getPostParameter(String name) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.getPostParameters().get(name);
    }

    @NotNull
    public Map<String, String> getPostParameters() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.postParameters != null) {
            return this.postParameters;
        }
        if (this.body == null) {
            throw new NullPointerException("Body must be loaded to decode post parameters");
        }
        this.postParameters = this.containsPostParameters() ? UrlParser.parseQueryIntoMap(this.body.array(), this.body.head(), this.body.tail()) : Collections.emptyMap();
        return this.postParameters;
    }

    public boolean containsPostParameters() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.method != HttpMethod.POST && this.method != HttpMethod.PUT) {
            return false;
        }
        String contentType = this.getHeader(HttpHeaders.CONTENT_TYPE);
        return contentType != null && contentType.startsWith("application/x-www-form-urlencoded");
    }

    public boolean containsMultipartData() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.method != HttpMethod.POST && this.method != HttpMethod.PUT) {
            return false;
        }
        String contentType = this.getHeader(HttpHeaders.CONTENT_TYPE);
        return contentType != null && contentType.startsWith("multipart/form-data; boundary=");
    }

    @NotNull
    public Map<String, String> getPathParameters() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.pathParameters != null ? this.pathParameters : Collections.emptyMap();
    }

    @NotNull
    public String getPathParameter(@NotNull String key) {
        String pathParameter;
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.pathParameters != null && (pathParameter = this.pathParameters.get(key)) != null) {
            return pathParameter;
        }
        throw new IllegalArgumentException("No path parameter '" + key + "' found");
    }

    public Promise<Void> handleMultipart(MultipartDecoder.MultipartDataHandler multipartDataHandler) {
        String contentType;
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if ((contentType = this.getHeader(HttpHeaders.CONTENT_TYPE)) == null || !contentType.startsWith("multipart/form-data; boundary=")) {
            return Promise.ofException((Throwable)HttpError.ofCode(400, "Content type is not multipart/form-data"));
        }
        String boundary = contentType.substring(30);
        if (boundary.startsWith("\"") && boundary.endsWith("\"")) {
            boundary = boundary.substring(1, boundary.length() - 1);
        }
        return MultipartDecoder.create(boundary).split(this.getBodyStream(), multipartDataHandler);
    }

    int getPos() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.pos;
    }

    void setPos(int pos) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.url.pos = (short)pos;
    }

    @NotNull
    public String getRelativePath() {
        String partialPath;
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return (partialPath = this.url.getPartialPath()).startsWith("/") ? partialPath.substring(1) : partialPath;
    }

    String pollUrlPart() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.pollUrlPart();
    }

    void removePathParameter(String key) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.pathParameters.remove(key);
    }

    void putPathParameter(String key, @NotNull String value) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.pathParameters == null) {
            this.pathParameters = new HashMap<String, String>();
        }
        this.pathParameters.put(key, UrlParser.urlParse(value));
    }

    @Override
    protected int estimateSize() {
        return this.estimateSize(13 + this.url.getPathAndQueryLength()) + HTTP_1_1_SIZE;
    }

    @Override
    protected void writeTo(@NotNull ByteBuf buf) {
        this.method.write(buf);
        buf.put((byte)32);
        this.url.writePathAndQuery(buf);
        buf.put(HTTP_1_1);
        this.writeHeaders(buf);
    }

    public String toString() {
        if (this.isRecycled()) {
            return "{Recycled HttpRequest}";
        }
        if (this.url.isRelativePath()) {
            String host = this.getHeader(HttpHeaders.HOST);
            return Utils.nullToEmpty((String)host) + this.url.getPathAndQuery();
        }
        return this.url.toString();
    }
}

