/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.exception.MalformedDataException;
import io.activej.http.HttpException;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.MalformedHttpException;
import io.activej.http.WebSocket;
import io.activej.http.WebSocketConstants;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Nullable;

public final class HttpUtils {
    private static final int URI_DEFAULT_CAPACITY = 32;
    static final byte EQUALS = 61;
    static final byte SEMICOLON = 59;
    static final byte COLON = 58;
    static final byte Q = 113;
    static final byte DOT = 46;
    static final byte ZERO = 48;
    static final byte COMMA = 44;

    public static InetAddress inetAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isInetAddress(String host) {
        int colons = 0;
        int dots = 0;
        byte[] bytes = ByteBufStrings.encodeAscii((String)host);
        if (bytes[0] == 91) {
            return bytes[bytes.length - 1] == 93 && HttpUtils.checkIpv6(bytes, 1, bytes.length - 1);
        }
        for (byte b : bytes) {
            if (b == 46) {
                ++dots;
                continue;
            }
            if (b == 58) {
                if (dots != 0) {
                    return false;
                }
                ++colons;
                continue;
            }
            if (Character.digit(b, 16) != -1) continue;
            return false;
        }
        if (dots < 4) {
            if (colons > 0 && colons < 8) {
                return HttpUtils.checkIpv6(bytes, 0, bytes.length);
            }
            return HttpUtils.checkIpv4(bytes, 0, bytes.length);
        }
        return false;
    }

    private static boolean checkIpv4(byte[] bytes, int pos, int length) {
        int start = pos;
        for (int i = pos; i < length; ++i) {
            int v;
            if (i == length - 1 && bytes[i] == 46) {
                return false;
            }
            if (bytes[i] != 46 && i != length - 1) continue;
            if (i - start == 0 && i != length - 1) {
                return false;
            }
            try {
                v = HttpUtils.trimAndDecodePositiveInt(bytes, start, i - start);
            }
            catch (MalformedHttpException e) {
                return false;
            }
            if (v < 0 || v > 255) {
                return false;
            }
            start = i + 1;
        }
        return true;
    }

    private static boolean checkIpv6(byte[] bytes, int pos, int length) {
        boolean shortHand = false;
        int numCount = 0;
        int blocksCount = 0;
        int start = 0;
        while (pos < length) {
            if (bytes[pos] == 58) {
                start = pos;
                ++blocksCount;
                numCount = 0;
                if (pos > 0 && bytes[pos - 1] == 58) {
                    if (shortHand) {
                        return false;
                    }
                    shortHand = true;
                }
            } else {
                if (bytes[pos] == 46) {
                    return HttpUtils.checkIpv4(bytes, start + 1, length - start + 1);
                }
                if (Character.digit(bytes[pos], 16) == -1) {
                    return false;
                }
                if (++numCount > 4) {
                    return false;
                }
            }
            ++pos;
        }
        return blocksCount > 6 || shortHand;
    }

    public static int skipSpaces(byte[] bytes, int pos, int end) {
        while (pos < end && bytes[pos] == 32) {
            ++pos;
        }
        return pos;
    }

    public static int decodeQ(byte[] bytes, int pos, int length) throws MalformedHttpException {
        if (bytes[pos] == 49) {
            return 100;
        }
        if (bytes[pos] == 48) {
            if (length == 1) {
                return 0;
            }
            length = length > 4 ? 2 : length - 2;
            int q = HttpUtils.trimAndDecodePositiveInt(bytes, pos + 2, length);
            if (length == 1) {
                q *= 10;
            }
            return q;
        }
        throw new MalformedHttpException("Value of 'q' should start either from 0 or 1");
    }

    public static String renderQueryString(Map<String, String> q) {
        return HttpUtils.renderQueryString(q, "UTF-8");
    }

    public static String renderQueryString(Map<String, String> q, String enc) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : q.entrySet()) {
            String name = HttpUtils.urlEncode(e.getKey(), enc);
            sb.append(name);
            if (e.getValue() != null) {
                sb.append('=');
                sb.append(HttpUtils.urlEncode(e.getValue(), enc));
            }
            sb.append('&');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String urlEncode(String string, String enc) {
        try {
            return URLEncoder.encode(string, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Can't encode with supplied encoding: " + enc, e);
        }
    }

    public static String urlDecode(@Nullable String string, String enc) throws MalformedHttpException {
        if (string == null) {
            throw new MalformedHttpException("No string to decode");
        }
        try {
            return URLDecoder.decode(string, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedHttpException("Can't encode with supplied encoding: " + enc, e);
        }
    }

    public static int trimAndDecodePositiveInt(byte[] array, int pos, int len) throws MalformedHttpException {
        int left = HttpUtils.trimLeft(array, pos, len);
        len -= left;
        len -= HttpUtils.trimRight(array, pos += left, len);
        return HttpUtils.decodePositiveInt(array, pos, len);
    }

    private static int trimLeft(byte[] array, int pos, int len) {
        for (int i = 0; i < len; ++i) {
            if (array[pos + i] == 32 || array[pos + i] == 9) continue;
            return i;
        }
        return 0;
    }

    private static int trimRight(byte[] array, int pos, int len) {
        for (int i = len - 1; i >= 0; --i) {
            if (array[pos + i] == 32 || array[pos + i] == 9) continue;
            return len - i - 1;
        }
        return 0;
    }

    @Nullable
    public static String getFullUri(HttpRequest request, int builderCapacity) {
        String host = request.getHeader(HttpHeaders.HOST);
        if (host == null) {
            return null;
        }
        String query = request.getQuery();
        String fragment = request.getFragment();
        StringBuilder fullUriBuilder = new StringBuilder(builderCapacity).append(request.getProtocol().lowercase()).append("://").append(host).append(request.getPath());
        if (!query.isEmpty()) {
            fullUriBuilder.append("?").append(query);
        }
        if (!fragment.isEmpty()) {
            fullUriBuilder.append("#").append(fragment);
        }
        return fullUriBuilder.toString();
    }

    @Nullable
    public static String getFullUri(HttpRequest request) {
        return HttpUtils.getFullUri(request, 32);
    }

    public static String getHttpErrorTitle(int code) {
        switch (code) {
            case 400: {
                return "400. Bad Request";
            }
            case 402: {
                return "402. Payment Required";
            }
            case 403: {
                return "403. Forbidden";
            }
            case 404: {
                return "404. Not Found";
            }
            case 405: {
                return "405. Method Not Allowed";
            }
            case 406: {
                return "406. Not Acceptable";
            }
            case 408: {
                return "408. Request Timeout";
            }
            case 409: {
                return "409. Conflict";
            }
            case 410: {
                return "410. Gone";
            }
            case 411: {
                return "411. Length Required";
            }
            case 413: {
                return "413. Payload Too Large";
            }
            case 414: {
                return "414. URI Too Long";
            }
            case 415: {
                return "415. Unsupported Media Type";
            }
            case 417: {
                return "417. Expectation Failed";
            }
            case 426: {
                return "426. Upgrade Required";
            }
            case 500: {
                return "500. Internal Server Error";
            }
            case 501: {
                return "501. Not Implemented";
            }
            case 502: {
                return "502. Bad Gateway";
            }
            case 503: {
                return "503. Service Unavailable";
            }
            case 504: {
                return "504. Gateway Timeout";
            }
            case 505: {
                return "505. HTTP Version Not Supported";
            }
        }
        return code + ". Unknown HTTP code, returned from an error";
    }

    static String getWebSocketAnswer(String key) {
        String answer;
        try {
            answer = Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA-1").digest((key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return answer;
    }

    static byte[] generateWebSocketKey() {
        byte[] key = new byte[16];
        ThreadLocalRandom.current().nextBytes(key);
        return Base64.getEncoder().encode(key);
    }

    static boolean isAnswerInvalid(HttpResponse response, byte[] key) {
        String header = response.getHeader(HttpHeaders.SEC_WEBSOCKET_ACCEPT);
        return header == null || !HttpUtils.getWebSocketAnswer(new String(key, StandardCharsets.ISO_8859_1)).equals(header.trim());
    }

    static boolean isReservedCloseCode(int closeCode) {
        return closeCode < 1000 || closeCode >= 1004 && closeCode < 1007 || closeCode >= 1015 && closeCode < 3000;
    }

    static String getUTF8(ByteBuf buf) throws CharacterCodingException {
        return StandardCharsets.UTF_8.newDecoder().decode(buf.toReadByteBuffer()).toString();
    }

    static WebSocketConstants.OpCode frameToOpType(WebSocket.Frame.FrameType frameType) {
        switch (frameType) {
            case TEXT: {
                return WebSocketConstants.OpCode.OP_TEXT;
            }
            case BINARY: {
                return WebSocketConstants.OpCode.OP_BINARY;
            }
            case CONTINUATION: {
                return WebSocketConstants.OpCode.OP_CONTINUATION;
            }
        }
        throw new AssertionError();
    }

    static WebSocket.Frame.FrameType opToFrameType(WebSocketConstants.OpCode opType) {
        switch (opType) {
            case OP_TEXT: {
                return WebSocket.Frame.FrameType.TEXT;
            }
            case OP_BINARY: {
                return WebSocket.Frame.FrameType.BINARY;
            }
            case OP_CONTINUATION: {
                return WebSocket.Frame.FrameType.CONTINUATION;
            }
        }
        throw new AssertionError();
    }

    static WebSocket.Message.MessageType frameToMessageType(WebSocket.Frame.FrameType frameType) {
        switch (frameType) {
            case TEXT: {
                return WebSocket.Message.MessageType.TEXT;
            }
            case BINARY: {
                return WebSocket.Message.MessageType.BINARY;
            }
        }
        throw new AssertionError();
    }

    static Throwable translateToHttpException(Throwable e) {
        if (e instanceof HttpException) {
            return e;
        }
        if (e instanceof MalformedDataException) {
            return new MalformedHttpException(e);
        }
        return new HttpException(e);
    }

    static int decodePositiveInt(byte[] array, int pos, int len) throws MalformedHttpException {
        int result = 0;
        for (int i = pos; i < pos + len; ++i) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new MalformedHttpException("Not a decimal value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            if ((result = b + result * 10) >= 0) continue;
            throw new MalformedHttpException("Bigger than max int value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
        }
        return result;
    }

    static int decodeUtf8(byte[] array, int pos, int len, char[] buffer, int to) throws MalformedHttpException {
        int end = pos + len;
        try {
            while (pos < end) {
                int c = array[pos++] & 0xFF;
                switch (c >> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        buffer[to++] = (char)c;
                        break;
                    }
                    case 12: 
                    case 13: {
                        buffer[to++] = (char)((c & 0x1F) << 6 | array[pos++] & 0x3F);
                        break;
                    }
                    case 14: {
                        buffer[to++] = (char)((c & 0xF) << 12 | (array[pos++] & 0x3F) << 6 | array[pos++] & 0x3F);
                    }
                }
            }
            if (pos > end) {
                throw new MalformedHttpException("Malformed utf-8 input: Read past end");
            }
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new MalformedHttpException("Malformed utf-8 input");
        }
        return to;
    }

    static int hashCodeCI(byte[] array, int offset, int size) {
        int result = 0;
        for (int i = offset; i < offset + size; ++i) {
            byte b = array[i];
            result += b | 0x20;
        }
        return result;
    }

    static int hashCodeCI(byte[] array) {
        return HttpUtils.hashCodeCI(array, 0, array.length);
    }
}

