/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.exception.UncheckedException;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.promise.Promise;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggableServlet
implements AsyncServlet {
    private static final Logger logger = LoggerFactory.getLogger(LoggableServlet.class);
    private static final BiFunction<HttpRequest, HttpResponse, String> DEFAULT_LOGGER_FUNCTION = (req, res) -> {
        int code = -1;
        String message = null;
        if (res != null) {
            code = res.getCode();
            ByteBuf body = res.isBodyLoaded() ? res.getBody() : null;
            message = body != null && code >= 400 && code < 500 ? body.asString(StandardCharsets.UTF_8) : null;
        }
        return "HttpRequest[url: '" + (req != null ? req.getUrl() : "") + "'], HttpResponse[code: " + (code != -1 ? Integer.valueOf(code) : "") + (message != null ? " message:'" + message + "'" : "") + "]";
    };
    private final AsyncServlet rootServlet;
    private final BiFunction<HttpRequest, HttpResponse, String> loggerFunction;

    private LoggableServlet(AsyncServlet rootServlet, BiFunction<HttpRequest, HttpResponse, String> loggerFunction) {
        this.rootServlet = rootServlet;
        this.loggerFunction = loggerFunction;
    }

    public static LoggableServlet create(AsyncServlet rootServlet) {
        return new LoggableServlet(rootServlet, DEFAULT_LOGGER_FUNCTION);
    }

    public static LoggableServlet create(AsyncServlet rootServlet, BiFunction<HttpRequest, @Nullable HttpResponse, String> loggerFunction) {
        return new LoggableServlet(rootServlet, loggerFunction);
    }

    @NotNull
    public Promise<HttpResponse> serve(@NotNull HttpRequest request) throws UncheckedException {
        Promise httpResponsePromise = this.rootServlet.serve(request).promise();
        if (!httpResponsePromise.isComplete()) {
            logger.trace(this.loggerFunction.apply(request, null));
        }
        return httpResponsePromise.whenComplete((res, e) -> {
            if (e != null) {
                logger.error("Exception", e);
            } else {
                logger.info(this.loggerFunction.apply(request, (HttpResponse)res));
            }
        });
    }
}

